// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: SurfCompPrepPluginInfo.h
// ****************************************************************************

#ifndef SURFCOMPPREP_PLUGIN_INFO_H
#define SURFCOMPPREP_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class SurfCompPrepAttributes;

// ****************************************************************************
//  Class: SurfCompPrepPluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an SurfCompPrep operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class SurfCompPrepGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class SurfCompPrepCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual SurfCompPrepGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class SurfCompPrepGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual SurfCompPrepCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
};

class SurfCompPrepViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual SurfCompPrepCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;

    static void InitializeGlobalObjects();
  private:
    static SurfCompPrepAttributes *defaultAtts;
    static SurfCompPrepAttributes *clientAtts;
};

class SurfCompPrepViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual SurfCompPrepViewerEnginePluginInfo
{
  public:
};

class SurfCompPrepEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual SurfCompPrepViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class SurfCompPrepScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual SurfCompPrepCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
