// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: SurfCompPrepPluginInfo.C
// ****************************************************************************

#include <SurfCompPrepPluginInfo.h>
#include <SurfCompPrepAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(SurfCompPrep,OP_EXPORT)

VISIT_OPERATOR_PLUGIN_ENTRY(SurfCompPrep,General)

// ****************************************************************************
//  Method: SurfCompPrepGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the operator plugin.
//
//  Returns:    A pointer to the name of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
SurfCompPrepGeneralPluginInfo::GetName() const
{
    return "SurfCompPrep";
}

// ****************************************************************************
//  Method: SurfCompPrepGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the operator plugin.
//
//  Returns:    A pointer to the version of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
SurfCompPrepGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: SurfCompPrepGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the operator plugin.
//
//  Returns:    A pointer to the id of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
SurfCompPrepGeneralPluginInfo::GetID() const
{
    return "SurfCompPrep_1.0";
}
// ****************************************************************************
//  Method: SurfCompPrepGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
SurfCompPrepGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}

// ****************************************************************************
//  Method: SurfCompPrepGeneralPluginInfo::GetCategoryName
//
//  Purpose:
//    Return the category name to which the operator belongs.
//
//  Returns:    Return the category name to which the operator belongs.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
SurfCompPrepGeneralPluginInfo::GetCategoryName() const
{
    return "Analysis";
}
