// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: SurfCompPrepCommonPluginInfo.C
// ****************************************************************************

#include <SurfCompPrepPluginInfo.h>
#include <SurfCompPrepAttributes.h>

// ****************************************************************************
//  Method: SurfCompPrepCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
SurfCompPrepCommonPluginInfo::AllocAttributes()
{
    return new SurfCompPrepAttributes;
}

// ****************************************************************************
//  Method: SurfCompPrepCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a SurfCompPrep attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
SurfCompPrepCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((SurfCompPrepAttributes *) to) = *((SurfCompPrepAttributes *) from);
}
