// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef QVISSURFCOMPPREPWINDOW_H
#define QVISSURFCOMPPREPWINDOW_H

#include <QvisOperatorWindow.h>
#include <AttributeSubject.h>

class SurfCompPrepAttributes;
class QLabel;
class QLineEdit;
class QButtonGroup;

// ****************************************************************************
// Class: QvisSurfCompPrepWindow
//
// Purpose:
//    Defines QvisSurfCompPrepWindow class.
//
// Notes:      Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

class QvisSurfCompPrepWindow : public QvisOperatorWindow
{
    Q_OBJECT
  public:
    QvisSurfCompPrepWindow(const int type,
                         SurfCompPrepAttributes *subj,
                         const QString &caption = QString::null,
                         const QString &shortName = QString::null,
                         QvisNotepadArea *notepad = 0);
    virtual ~QvisSurfCompPrepWindow();
    virtual void CreateWindowContents();
  protected:
    void UpdateWindow(bool doAll);
    virtual void GetCurrentValues(int which_widget);
  private slots:
    void surfaceTypeChanged(int val);
    void coordSystemChanged(int val);
    void thetaStartProcessText();
    void thetaStopProcessText();
    void thetaStepsProcessText();
    void phiStartProcessText();
    void phiStopProcessText();
    void phiStepsProcessText();
    void startRadiusProcessText();
    void endRadiusProcessText();
    void radiusStepsProcessText();
    void xStartProcessText();
    void xStopProcessText();
    void xStepsProcessText();
    void yStartProcessText();
    void yStopProcessText();
    void yStepsProcessText();
    void zStartProcessText();
    void zStopProcessText();
    void zStepsProcessText();
  private:
    QButtonGroup *surfaceType;
    QButtonGroup *coordSystem;
    QLineEdit *thetaStart;
    QLineEdit *thetaStop;
    QLineEdit *thetaSteps;
    QLineEdit *phiStart;
    QLineEdit *phiStop;
    QLineEdit *phiSteps;
    QLineEdit *startRadius;
    QLineEdit *endRadius;
    QLineEdit *radiusSteps;
    QLineEdit *xStart;
    QLineEdit *xStop;
    QLineEdit *xSteps;
    QLineEdit *yStart;
    QLineEdit *yStop;
    QLineEdit *ySteps;
    QLineEdit *zStart;
    QLineEdit *zStop;
    QLineEdit *zSteps;
    QLabel *surfaceTypeLabel;
    QLabel *coordSystemLabel;
    QLabel *thetaStartLabel;
    QLabel *thetaStopLabel;
    QLabel *thetaStepsLabel;
    QLabel *phiStartLabel;
    QLabel *phiStopLabel;
    QLabel *phiStepsLabel;
    QLabel *startRadiusLabel;
    QLabel *endRadiusLabel;
    QLabel *radiusStepsLabel;
    QLabel *xStartLabel;
    QLabel *xStopLabel;
    QLabel *xStepsLabel;
    QLabel *yStartLabel;
    QLabel *yStopLabel;
    QLabel *yStepsLabel;
    QLabel *zStartLabel;
    QLabel *zStopLabel;
    QLabel *zStepsLabel;

    SurfCompPrepAttributes *atts;
};



#endif
