// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: SubdivideQuadsViewerEnginePluginInfo.C
// ****************************************************************************

#include <SubdivideQuadsPluginInfo.h>
#include <SubdivideQuadsAttributes.h>

//
// Storage for static data elements.
//
SubdivideQuadsAttributes *SubdivideQuadsViewerEnginePluginInfo::clientAtts = NULL;
SubdivideQuadsAttributes *SubdivideQuadsViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  SubdivideQuadsViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
SubdivideQuadsViewerEnginePluginInfo::InitializeGlobalObjects()
{
    if (SubdivideQuadsViewerEnginePluginInfo::clientAtts == NULL)
    {
        SubdivideQuadsViewerEnginePluginInfo::clientAtts  = new SubdivideQuadsAttributes;
        SubdivideQuadsViewerEnginePluginInfo::defaultAtts = new SubdivideQuadsAttributes;
    }
}

// ****************************************************************************
//  Method: SubdivideQuadsViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
SubdivideQuadsViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: SubdivideQuadsViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
SubdivideQuadsViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: SubdivideQuadsViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
SubdivideQuadsViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(SubdivideQuadsAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: SubdivideQuadsViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
SubdivideQuadsViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(SubdivideQuadsAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: SubdivideQuadsViewerEnginePluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts        The attribute subject to initialize.
//    plot        The viewer plot that owns the operator.
//    fromDefault True to initialize the attributes from the defaults. False
//                to initialize from the current attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
SubdivideQuadsViewerEnginePluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const avtPlotMetaData &plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(SubdivideQuadsAttributes*)atts = *defaultAtts;
    else
        *(SubdivideQuadsAttributes*)atts = *clientAtts;

    UpdateOperatorAtts(atts, plot);
}

// ****************************************************************************
//  Method: SubdivideQuadsViewerEnginePluginInfo::UpdateOperatorAtts
//
//  Purpose:
//    Update the operator attributes when using operator expressions.
//
//  Arguments:
//    atts        The attribute subject to update.
//    plot        The viewer plot that owns the operator.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
SubdivideQuadsViewerEnginePluginInfo::UpdateOperatorAtts(AttributeSubject *atts, const avtPlotMetaData &plot)
{
}

// ****************************************************************************
//  Method: SubdivideQuadsViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
SubdivideQuadsViewerEnginePluginInfo::GetMenuName() const
{
    return "SubdivideQuads";
}

