// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: SubdivideQuadsCommonPluginInfo.C
// ****************************************************************************

#include <SubdivideQuadsPluginInfo.h>
#include <SubdivideQuadsAttributes.h>

// ****************************************************************************
//  Method: SubdivideQuadsCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
SubdivideQuadsCommonPluginInfo::AllocAttributes()
{
    return new SubdivideQuadsAttributes;
}

// ****************************************************************************
//  Method: SubdivideQuadsCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a SubdivideQuads attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
SubdivideQuadsCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((SubdivideQuadsAttributes *) to) = *((SubdivideQuadsAttributes *) from);
}
