// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef SUBDIVIDEQUADSATTRIBUTES_H
#define SUBDIVIDEQUADSATTRIBUTES_H
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: SubdivideQuadsAttributes
//
// Purpose:
//    Attributes for SubdivideQuads operator
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class SubdivideQuadsAttributes : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    SubdivideQuadsAttributes();
    SubdivideQuadsAttributes(const SubdivideQuadsAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    SubdivideQuadsAttributes(private_tmfs_t tmfs);
    SubdivideQuadsAttributes(const SubdivideQuadsAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~SubdivideQuadsAttributes();

    virtual SubdivideQuadsAttributes& operator = (const SubdivideQuadsAttributes &obj);
    virtual bool operator == (const SubdivideQuadsAttributes &obj) const;
    virtual bool operator != (const SubdivideQuadsAttributes &obj) const;
private:
    void Init();
    void Copy(const SubdivideQuadsAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectVariable();

    // Property setting methods
    void SetThreshold(double threshold_);
    void SetMaxSubdivs(int maxSubdivs_);
    void SetFanOutPoints(bool fanOutPoints_);
    void SetDoTriangles(bool doTriangles_);
    void SetVariable(const std::string &variable_);

    // Property getting methods
    double            GetThreshold() const;
    int               GetMaxSubdivs() const;
    bool              GetFanOutPoints() const;
    bool              GetDoTriangles() const;
    const std::string &GetVariable() const;
          std::string &GetVariable();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_threshold = 0,
        ID_maxSubdivs,
        ID_fanOutPoints,
        ID_doTriangles,
        ID_variable,
        ID__LAST
    };

private:
    double      threshold;
    int         maxSubdivs;
    bool        fanOutPoints;
    bool        doTriangles;
    std::string variable;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define SUBDIVIDEQUADSATTRIBUTES_TMFS "dibbs"

#endif
