// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  StatisticalTrendsScriptingPluginInfo.C
// ************************************************************************* //
#include <PyStatisticalTrendsAttributes.h>
#include <StatisticalTrendsPluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(StatisticalTrends,Scripting)

// ****************************************************************************
// Method: StatisticalTrendsScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
StatisticalTrendsScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyStatisticalTrendsAttributes_StartUp((StatisticalTrendsAttributes *)subj, data);
}

// ****************************************************************************
// Method: StatisticalTrendsScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
StatisticalTrendsScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyStatisticalTrendsAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: StatisticalTrendsScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is StatisticalTrends plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
StatisticalTrendsScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyStatisticalTrendsAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: StatisticalTrendsScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
StatisticalTrendsScriptingPluginInfo::GetLogString()
{
    std::string s(PyStatisticalTrendsAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: StatisticalTrendsScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
StatisticalTrendsScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyStatisticalTrendsAttributes_SetDefaults((const StatisticalTrendsAttributes *)atts);
}
