// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: StatisticalTrendsCommonPluginInfo.C
// ****************************************************************************

#include <StatisticalTrendsPluginInfo.h>
#include <StatisticalTrendsAttributes.h>

#include <Expression.h>
#include <ExpressionList.h>
#include <avtDatabaseMetaData.h>
#include <avtScalarMetaData.h>

// ****************************************************************************
//  Method: StatisticalTrendsCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
StatisticalTrendsCommonPluginInfo::AllocAttributes()
{
    return new StatisticalTrendsAttributes;
}

// ****************************************************************************
//  Method: StatisticalTrendsCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a StatisticalTrends attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
StatisticalTrendsCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((StatisticalTrendsAttributes *) to) = *((StatisticalTrendsAttributes *) from);
}

// ****************************************************************************
//  Method: StatisticalTrendsCommonPluginInfo::GetCreatedExpressions
//
//  Purpose:
//      Gets the expressions created by this operator.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

ExpressionList *
StatisticalTrendsCommonPluginInfo::GetCreatedExpressions(const avtDatabaseMetaData *md) const
{
    int t, i;
    char name[1024], defn[1024];
    ExpressionList *el = new ExpressionList;
    int numScalars = md->GetNumScalars();

    const char numTypes = 6;
    const char *typeString[6] = { "Sum", "Mean", "Variance",
                                  "Std. Dev.", "Slope", "Residuals" };

    for (t = 0 ; t < numTypes ; t++)
    {
        for (i = 0 ; i < numScalars ; i++)
        {
            const avtScalarMetaData *mmd = md->GetScalar(i);
            if (mmd->hideFromGUI || !mmd->validVariable)
                continue;

            {
                Expression e2;
                sprintf(name, "operators/StatisticalTrends/%s/%s",
                typeString[t], mmd->name.c_str());
                e2.SetName(name);
                e2.SetType(Expression::ScalarMeshVar);
                e2.SetFromOperator(true);
                e2.SetOperatorName("StatisticalTrends");
                sprintf(defn, "cell_constant(<%s>, 0.)", mmd->name.c_str());
                e2.SetDefinition(defn);
                el->AddExpressions(e2);
            }
        }
    }

    const ExpressionList &oldEL = md->GetExprList();

    for (t = 0 ; t < numTypes ; t++)
    {
        for (i = 0 ; i < oldEL.GetNumExpressions() ; i++)
        {
            const Expression &e = oldEL.GetExpressions(i);
            if (e.GetType() == Expression::ScalarMeshVar)
            {
                if (e.GetFromOperator() || e.GetAutoExpression())
                    continue; // weird ordering behavior otherwise
                Expression e2;
                sprintf(name, "operators/StatisticalTrends/%s/%s",
                        typeString[t], e.GetName().c_str());
                e2.SetName(name);
                e2.SetType(Expression::ScalarMeshVar);
                e2.SetFromOperator(true);
                e2.SetOperatorName("StatisticalTrends");
                sprintf(defn, "cell_constant(<%s>, 0.)", e.GetName().c_str());
                e2.SetDefinition(defn);
                el->AddExpressions(e2);
            }
        }
    }

    return el;
}

