// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef QVISSTATISTICALTRENDSWINDOW_H
#define QVISSTATISTICALTRENDSWINDOW_H

#include <QvisOperatorWindow.h>
#include <AttributeSubject.h>

class StatisticalTrendsAttributes;
class QGroupBox;
class QLabel;
class QLineEdit;
class QButtonGroup;

// ****************************************************************************
// Class: QvisStatisticalTrendsWindow
//
// Purpose:
//    Defines QvisStatisticalTrendsWindow class.
//
// Notes:      Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

class QvisStatisticalTrendsWindow : public QvisOperatorWindow
{
    Q_OBJECT
  public:
    QvisStatisticalTrendsWindow(const int type,
                         StatisticalTrendsAttributes *subj,
                         const QString &caption = QString::null,
                         const QString &shortName = QString::null,
                         QvisNotepadArea *notepad = 0);
    virtual ~QvisStatisticalTrendsWindow();
    virtual void CreateWindowContents();
  protected:
    void UpdateWindow(bool doAll);
    virtual void GetCurrentValues(int which_widget);
  private slots:
    void startIndexProcessText();
    void stopIndexProcessText();
    void strideProcessText();
    void startTrendTypeChanged(int val);
    void stopTrendTypeChanged(int val);
    void updateStopIndexText();
    void updateStartIndexText();
    void statisticTypeChanged(int val);
    void trendAxisChanged(int val);

  private:
    QLineEdit *startIndex;
    QLineEdit *stopIndex;
    QLineEdit *stride;
    QWidget      *startTrendType;
    QButtonGroup *startTrendTypeButtonGroup;
    QWidget      *stopTrendType;
    QButtonGroup *stopTrendTypeButtonGroup;
    QLabel *startIndexLabel;
    QLabel *stopIndexLabel;
    QLabel *strideLabel;
    QLabel *startTrendTypeLabel;
    QLabel *stopTrendTypeLabel;
    QGroupBox * statisticGroup;
    QButtonGroup *statisticTypeButtonGroup;
    QGroupBox * trendAxisGroup;
    QButtonGroup *trendAxisButtonGroup;

    StatisticalTrendsAttributes *atts;
};

#endif
