// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtStaggerFilter.h
// ************************************************************************* //

#ifndef AVT_Stagger_FILTER_H
#define AVT_Stagger_FILTER_H

#include <avtPluginDataTreeIterator.h>

#include <StaggerAttributes.h>


// ****************************************************************************
//  Class: avtStaggerFilter
//
//  Purpose:
//      A plugin operator for Stagger.
//
//  Programmer: mdurant -- generated by xml2avt
//  Creation:   Fri Mar 23 12:44:32 PDT 2012
//
//  Modifications:
//    Eric Brugger, Thu Aug 14 16:45:17 PDT 2014
//    Modified the class to work with avtDataRepresentation.
//
// ****************************************************************************

class avtStaggerFilter : public avtPluginDataTreeIterator
{
  public:
                         avtStaggerFilter();
    virtual             ~avtStaggerFilter();

    static avtFilter    *Create();

    virtual const char  *GetType(void)  { return "avtStaggerFilter"; };
    virtual const char  *GetDescription(void)
                             { return "Stagger"; };

    virtual void         SetAtts(const AttributeGroup*);
    virtual bool         Equivalent(const AttributeGroup*);

  protected:
    StaggerAttributes   atts;

    virtual avtDataRepresentation *ExecuteData(avtDataRepresentation *);
    virtual void          UpdateDataObjectInfo(void);
};


#endif
