// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: StaggerPluginInfo.h
// ****************************************************************************

#ifndef STAGGER_PLUGIN_INFO_H
#define STAGGER_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class StaggerAttributes;

// ****************************************************************************
//  Class: StaggerPluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an Stagger operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class StaggerGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class StaggerCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual StaggerGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class StaggerGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual StaggerCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
};

class StaggerViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual StaggerCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;

    static void InitializeGlobalObjects();
  private:
    static StaggerAttributes *defaultAtts;
    static StaggerAttributes *clientAtts;
};

class StaggerViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual StaggerViewerEnginePluginInfo
{
  public:
};

class StaggerEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual StaggerViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class StaggerScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual StaggerCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
