// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: StaggerCommonPluginInfo.C
// ****************************************************************************

#include <StaggerPluginInfo.h>
#include <StaggerAttributes.h>

// ****************************************************************************
//  Method: StaggerCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
StaggerCommonPluginInfo::AllocAttributes()
{
    return new StaggerAttributes;
}

// ****************************************************************************
//  Method: StaggerCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a Stagger attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
StaggerCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((StaggerAttributes *) to) = *((StaggerAttributes *) from);
}
