// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <StaggerAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: StaggerAttributes::StaggerAttributes
//
// Purpose:
//   Init utility for the StaggerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void StaggerAttributes::Init()
{
    offsetX = 0;
    offsetY = 0;
    offsetZ = 0;

    StaggerAttributes::SelectAll();
}

// ****************************************************************************
// Method: StaggerAttributes::StaggerAttributes
//
// Purpose:
//   Copy utility for the StaggerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void StaggerAttributes::Copy(const StaggerAttributes &obj)
{
    offsetX = obj.offsetX;
    offsetY = obj.offsetY;
    offsetZ = obj.offsetZ;

    StaggerAttributes::SelectAll();
}

// Type map format string
const char *StaggerAttributes::TypeMapFormatString = STAGGERATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t StaggerAttributes::TmfsStruct = {STAGGERATTRIBUTES_TMFS};


// ****************************************************************************
// Method: StaggerAttributes::StaggerAttributes
//
// Purpose:
//   Default constructor for the StaggerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

StaggerAttributes::StaggerAttributes() :
    AttributeSubject(StaggerAttributes::TypeMapFormatString)
{
    StaggerAttributes::Init();
}

// ****************************************************************************
// Method: StaggerAttributes::StaggerAttributes
//
// Purpose:
//   Constructor for the derived classes of StaggerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

StaggerAttributes::StaggerAttributes(private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    StaggerAttributes::Init();
}

// ****************************************************************************
// Method: StaggerAttributes::StaggerAttributes
//
// Purpose:
//   Copy constructor for the StaggerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

StaggerAttributes::StaggerAttributes(const StaggerAttributes &obj) :
    AttributeSubject(StaggerAttributes::TypeMapFormatString)
{
    StaggerAttributes::Copy(obj);
}

// ****************************************************************************
// Method: StaggerAttributes::StaggerAttributes
//
// Purpose:
//   Copy constructor for derived classes of the StaggerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

StaggerAttributes::StaggerAttributes(const StaggerAttributes &obj, private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    StaggerAttributes::Copy(obj);
}

// ****************************************************************************
// Method: StaggerAttributes::~StaggerAttributes
//
// Purpose:
//   Destructor for the StaggerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

StaggerAttributes::~StaggerAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: StaggerAttributes::operator =
//
// Purpose:
//   Assignment operator for the StaggerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

StaggerAttributes&
StaggerAttributes::operator = (const StaggerAttributes &obj)
{
    if (this == &obj) return *this;

    StaggerAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: StaggerAttributes::operator ==
//
// Purpose:
//   Comparison operator == for the StaggerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
StaggerAttributes::operator == (const StaggerAttributes &obj) const
{
    // Create the return value
    return ((offsetX == obj.offsetX) &&
            (offsetY == obj.offsetY) &&
            (offsetZ == obj.offsetZ));
}

// ****************************************************************************
// Method: StaggerAttributes::operator !=
//
// Purpose:
//   Comparison operator != for the StaggerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
StaggerAttributes::operator != (const StaggerAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: StaggerAttributes::TypeName
//
// Purpose:
//   Type name method for the StaggerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

const std::string
StaggerAttributes::TypeName() const
{
    return "StaggerAttributes";
}

// ****************************************************************************
// Method: StaggerAttributes::CopyAttributes
//
// Purpose:
//   CopyAttributes method for the StaggerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
StaggerAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const StaggerAttributes *tmp = (const StaggerAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: StaggerAttributes::CreateCompatible
//
// Purpose:
//   CreateCompatible method for the StaggerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
StaggerAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new StaggerAttributes(*this);
    // Other cases could go here too.

    return retval;
}

// ****************************************************************************
// Method: StaggerAttributes::NewInstance
//
// Purpose:
//   NewInstance method for the StaggerAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
StaggerAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new StaggerAttributes(*this);
    else
        retval = new StaggerAttributes;

    return retval;
}

// ****************************************************************************
// Method: StaggerAttributes::SelectAll
//
// Purpose:
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
StaggerAttributes::SelectAll()
{
    Select(ID_offsetX, (void *)&offsetX);
    Select(ID_offsetY, (void *)&offsetY);
    Select(ID_offsetZ, (void *)&offsetZ);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: StaggerAttributes::CreateNode
//
// Purpose:
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
StaggerAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    StaggerAttributes defaultObject;
    bool addToParent = false;
    // Create a node for StaggerAttributes.
    DataNode *node = new DataNode("StaggerAttributes");

    if(completeSave || !FieldsEqual(ID_offsetX, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("offsetX", offsetX));
    }

    if(completeSave || !FieldsEqual(ID_offsetY, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("offsetY", offsetY));
    }

    if(completeSave || !FieldsEqual(ID_offsetZ, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("offsetZ", offsetZ));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: StaggerAttributes::SetFromNode
//
// Purpose:
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
StaggerAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("StaggerAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("offsetX")) != 0)
        SetOffsetX(node->AsDouble());
    if((node = searchNode->GetNode("offsetY")) != 0)
        SetOffsetY(node->AsDouble());
    if((node = searchNode->GetNode("offsetZ")) != 0)
        SetOffsetZ(node->AsDouble());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
StaggerAttributes::SetOffsetX(double offsetX_)
{
    offsetX = offsetX_;
    Select(ID_offsetX, (void *)&offsetX);
}

void
StaggerAttributes::SetOffsetY(double offsetY_)
{
    offsetY = offsetY_;
    Select(ID_offsetY, (void *)&offsetY);
}

void
StaggerAttributes::SetOffsetZ(double offsetZ_)
{
    offsetZ = offsetZ_;
    Select(ID_offsetZ, (void *)&offsetZ);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

double
StaggerAttributes::GetOffsetX() const
{
    return offsetX;
}

double
StaggerAttributes::GetOffsetY() const
{
    return offsetY;
}

double
StaggerAttributes::GetOffsetZ() const
{
    return offsetZ;
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: StaggerAttributes::GetFieldName
//
// Purpose:
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
StaggerAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_offsetX: return "offsetX";
    case ID_offsetY: return "offsetY";
    case ID_offsetZ: return "offsetZ";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: StaggerAttributes::GetFieldType
//
// Purpose:
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeGroup::FieldType
StaggerAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_offsetX: return FieldType_double;
    case ID_offsetY: return FieldType_double;
    case ID_offsetZ: return FieldType_double;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: StaggerAttributes::GetFieldTypeName
//
// Purpose:
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
StaggerAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_offsetX: return "double";
    case ID_offsetY: return "double";
    case ID_offsetZ: return "double";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: StaggerAttributes::FieldsEqual
//
// Purpose:
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
StaggerAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const StaggerAttributes &obj = *((const StaggerAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_offsetX:
        {  // new scope
        retval = (offsetX == obj.offsetX);
        }
        break;
    case ID_offsetY:
        {  // new scope
        retval = (offsetY == obj.offsetY);
        }
        break;
    case ID_offsetZ:
        {  // new scope
        retval = (offsetZ == obj.offsetZ);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

