// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: SphereSliceGUIPluginInfo.C
// ****************************************************************************

#include <SphereSlicePluginInfo.h>
#include <SphereSliceAttributes.h>
#include <QApplication>
#include <QvisSphereSliceWindow.h>

VISIT_OPERATOR_PLUGIN_ENTRY(SphereSlice,GUI)

// ****************************************************************************
//  Method: SphereSliceGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QString *
SphereSliceGUIPluginInfo::GetMenuName() const
{
    return new QString(qApp->translate("OperatorNames", "Spherical Slice"));
}


// ****************************************************************************
//  Method: SphereSliceGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QvisPostableWindowObserver *
SphereSliceGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    const QString &caption, const QString &shortName, QvisNotepadArea *notepad)
{
    return new QvisSphereSliceWindow(type, (SphereSliceAttributes *)attr,
        caption, shortName, notepad);
}

// ****************************************************************************
//  Method: SphereSliceGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

#include <SphereSlice.xpm>
const char **
SphereSliceGUIPluginInfo::XPMIconData() const
{
    return SphereSlice_xpm;
}

