// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: SphereSliceCommonPluginInfo.C
// ****************************************************************************

#include <SphereSlicePluginInfo.h>
#include <SphereSliceAttributes.h>

// ****************************************************************************
//  Method: SphereSliceCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
SphereSliceCommonPluginInfo::AllocAttributes()
{
    return new SphereSliceAttributes;
}

// ****************************************************************************
//  Method: SphereSliceCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a SphereSlice attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
SphereSliceCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((SphereSliceAttributes *) to) = *((SphereSliceAttributes *) from);
}
