// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef QVISSPHERESLICEWINDOW_H
#define QVISSPHERESLICEWINDOW_H

#include <QvisOperatorWindow.h>
#include <AttributeSubject.h>

class SphereSliceAttributes;
class QLabel;
class QLineEdit;

// ****************************************************************************
// Class: QvisSphereSliceWindow
//
// Purpose:
//    Defines QvisSphereSliceWindow class.
//
// Notes:      Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

class QvisSphereSliceWindow : public QvisOperatorWindow
{
    Q_OBJECT
  public:
    QvisSphereSliceWindow(const int type,
                         SphereSliceAttributes *subj,
                         const QString &caption = QString::null,
                         const QString &shortName = QString::null,
                         QvisNotepadArea *notepad = 0);
    virtual ~QvisSphereSliceWindow();
    virtual void CreateWindowContents();
  protected:
    void UpdateWindow(bool doAll);
    virtual void GetCurrentValues(int which_widget);
  private slots:
    void originProcessText();
    void radiusProcessText();
  private:
    QLineEdit *origin;
    QLineEdit *radius;
    QLabel *originLabel;
    QLabel *radiusLabel;

    SphereSliceAttributes *atts;
};



#endif
