// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include "QvisSphereSliceWindow.h"

#include <SphereSliceAttributes.h>

#include <QLabel>
#include <QLayout>
#include <QLineEdit>


// ****************************************************************************
// Method: QvisSphereSliceWindow::QvisSphereSliceWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisSphereSliceWindow::QvisSphereSliceWindow(const int type,
                         SphereSliceAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisSphereSliceWindow::~QvisSphereSliceWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisSphereSliceWindow::~QvisSphereSliceWindow()
{
}


// ****************************************************************************
// Method: QvisSphereSliceWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisSphereSliceWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    originLabel = new QLabel(tr("Origin"), central);
    mainLayout->addWidget(originLabel,0,0);
    origin = new QLineEdit(central);
    connect(origin, SIGNAL(returnPressed()),
            this, SLOT(originProcessText()));
    mainLayout->addWidget(origin, 0,1);

    radiusLabel = new QLabel(tr("Radius"), central);
    mainLayout->addWidget(radiusLabel,1,0);
    radius = new QLineEdit(central);
    connect(radius, SIGNAL(returnPressed()),
            this, SLOT(radiusProcessText()));
    mainLayout->addWidget(radius, 1,1);

}


// ****************************************************************************
// Method: QvisSphereSliceWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisSphereSliceWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case SphereSliceAttributes::ID_origin:
            origin->setText(DoublesToQString(atts->GetOrigin(), 3));
            break;
          case SphereSliceAttributes::ID_radius:
            radius->setText(DoubleToQString(atts->GetRadius()));
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisSphereSliceWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisSphereSliceWindow::GetCurrentValues(int which_widget)
{
    bool doAll = (which_widget == -1);

    // Do origin
    if(which_widget == SphereSliceAttributes::ID_origin || doAll)
    {
        double val[3];
        if(LineEditGetDoubles(origin, val, 3))
            atts->SetOrigin(val);
        else
        {
            ResettingError(tr("Origin"),
                DoublesToQString(atts->GetOrigin(),3));
            atts->SetOrigin(atts->GetOrigin());
        }
    }

    // Do radius
    if(which_widget == SphereSliceAttributes::ID_radius || doAll)
    {
        double val;
        if(LineEditGetDouble(radius, val))
            atts->SetRadius(val);
        else
        {
            ResettingError(tr("Radius"),
                DoubleToQString(atts->GetRadius()));
            atts->SetRadius(atts->GetRadius());
        }
    }

}


//
// Qt Slot functions
//


void
QvisSphereSliceWindow::originProcessText()
{
    GetCurrentValues(SphereSliceAttributes::ID_origin);
    Apply();
}


void
QvisSphereSliceWindow::radiusProcessText()
{
    GetCurrentValues(SphereSliceAttributes::ID_radius);
    Apply();
}


