// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtSmoothFilter.h
// ************************************************************************* //

#ifndef AVT_Smooth_FILTER_H
#define AVT_Smooth_FILTER_H

#include <avtPluginDataTreeIterator.h>

#include <SmoothOperatorAttributes.h>

class vtkDataSet;


// ****************************************************************************
//  Class: avtSmoothFilter
//
//  Purpose:
//      A plugin operator for Smooth.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sun Aug 14 11:59:58 PDT 2005
//
//  Modifications:
//    Jeremy Meredith, Fri Apr 30 16:54:29 EDT 2010
//    Removed warning for non-polydata -- just try to fix it instead.
//
//    Eric Brugger, Thu Aug 14 16:39:28 PDT 2014
//    Modified the class to work with avtDataRepresentation.
//
// ****************************************************************************

class avtSmoothFilter : public avtPluginDataTreeIterator
{
  public:
                         avtSmoothFilter();
    virtual             ~avtSmoothFilter();

    static avtFilter    *Create();

    virtual const char  *GetType(void)  { return "avtSmoothFilter"; };
    virtual const char  *GetDescription(void)
                             { return "Smooth"; };

    virtual void         SetAtts(const AttributeGroup*);
    virtual bool         Equivalent(const AttributeGroup*);

  protected:
    SmoothOperatorAttributes   atts;

    virtual avtDataRepresentation *ExecuteData(avtDataRepresentation *);
    virtual void          PreExecute(void);
    virtual void          UpdateDataObjectInfo(void);
};


#endif
