// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef SMOOTHOPERATORATTRIBUTES_H
#define SMOOTHOPERATORATTRIBUTES_H
#include <AttributeSubject.h>


// ****************************************************************************
// Class: SmoothOperatorAttributes
//
// Purpose:
//    Attributes for the Smooth Operator
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class SmoothOperatorAttributes : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    SmoothOperatorAttributes();
    SmoothOperatorAttributes(const SmoothOperatorAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    SmoothOperatorAttributes(private_tmfs_t tmfs);
    SmoothOperatorAttributes(const SmoothOperatorAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~SmoothOperatorAttributes();

    virtual SmoothOperatorAttributes& operator = (const SmoothOperatorAttributes &obj);
    virtual bool operator == (const SmoothOperatorAttributes &obj) const;
    virtual bool operator != (const SmoothOperatorAttributes &obj) const;
private:
    void Init();
    void Copy(const SmoothOperatorAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();

    // Property setting methods
    void SetNumIterations(int numIterations_);
    void SetRelaxationFactor(double relaxationFactor_);
    void SetConvergence(double convergence_);
    void SetMaintainFeatures(bool maintainFeatures_);
    void SetFeatureAngle(double featureAngle_);
    void SetEdgeAngle(double edgeAngle_);
    void SetSmoothBoundaries(bool smoothBoundaries_);

    // Property getting methods
    int    GetNumIterations() const;
    double GetRelaxationFactor() const;
    double GetConvergence() const;
    bool   GetMaintainFeatures() const;
    double GetFeatureAngle() const;
    double GetEdgeAngle() const;
    bool   GetSmoothBoundaries() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_numIterations = 0,
        ID_relaxationFactor,
        ID_convergence,
        ID_maintainFeatures,
        ID_featureAngle,
        ID_edgeAngle,
        ID_smoothBoundaries,
        ID__LAST
    };

private:
    int    numIterations;
    double relaxationFactor;
    double convergence;
    bool   maintainFeatures;
    double featureAngle;
    double edgeAngle;
    bool   smoothBoundaries;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define SMOOTHOPERATORATTRIBUTES_TMFS "iddbddb"

#endif
