// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <SmoothOperatorAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: SmoothOperatorAttributes::SmoothOperatorAttributes
//
// Purpose:
//   Init utility for the SmoothOperatorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void SmoothOperatorAttributes::Init()
{
    numIterations = 20;
    relaxationFactor = 0.01;
    convergence = 0;
    maintainFeatures = true;
    featureAngle = 45;
    edgeAngle = 15;
    smoothBoundaries = false;

    SmoothOperatorAttributes::SelectAll();
}

// ****************************************************************************
// Method: SmoothOperatorAttributes::SmoothOperatorAttributes
//
// Purpose:
//   Copy utility for the SmoothOperatorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void SmoothOperatorAttributes::Copy(const SmoothOperatorAttributes &obj)
{
    numIterations = obj.numIterations;
    relaxationFactor = obj.relaxationFactor;
    convergence = obj.convergence;
    maintainFeatures = obj.maintainFeatures;
    featureAngle = obj.featureAngle;
    edgeAngle = obj.edgeAngle;
    smoothBoundaries = obj.smoothBoundaries;

    SmoothOperatorAttributes::SelectAll();
}

// Type map format string
const char *SmoothOperatorAttributes::TypeMapFormatString = SMOOTHOPERATORATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t SmoothOperatorAttributes::TmfsStruct = {SMOOTHOPERATORATTRIBUTES_TMFS};


// ****************************************************************************
// Method: SmoothOperatorAttributes::SmoothOperatorAttributes
//
// Purpose:
//   Default constructor for the SmoothOperatorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

SmoothOperatorAttributes::SmoothOperatorAttributes() :
    AttributeSubject(SmoothOperatorAttributes::TypeMapFormatString)
{
    SmoothOperatorAttributes::Init();
}

// ****************************************************************************
// Method: SmoothOperatorAttributes::SmoothOperatorAttributes
//
// Purpose:
//   Constructor for the derived classes of SmoothOperatorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

SmoothOperatorAttributes::SmoothOperatorAttributes(private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    SmoothOperatorAttributes::Init();
}

// ****************************************************************************
// Method: SmoothOperatorAttributes::SmoothOperatorAttributes
//
// Purpose:
//   Copy constructor for the SmoothOperatorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

SmoothOperatorAttributes::SmoothOperatorAttributes(const SmoothOperatorAttributes &obj) :
    AttributeSubject(SmoothOperatorAttributes::TypeMapFormatString)
{
    SmoothOperatorAttributes::Copy(obj);
}

// ****************************************************************************
// Method: SmoothOperatorAttributes::SmoothOperatorAttributes
//
// Purpose:
//   Copy constructor for derived classes of the SmoothOperatorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

SmoothOperatorAttributes::SmoothOperatorAttributes(const SmoothOperatorAttributes &obj, private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    SmoothOperatorAttributes::Copy(obj);
}

// ****************************************************************************
// Method: SmoothOperatorAttributes::~SmoothOperatorAttributes
//
// Purpose:
//   Destructor for the SmoothOperatorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

SmoothOperatorAttributes::~SmoothOperatorAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: SmoothOperatorAttributes::operator =
//
// Purpose:
//   Assignment operator for the SmoothOperatorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

SmoothOperatorAttributes&
SmoothOperatorAttributes::operator = (const SmoothOperatorAttributes &obj)
{
    if (this == &obj) return *this;

    SmoothOperatorAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: SmoothOperatorAttributes::operator ==
//
// Purpose:
//   Comparison operator == for the SmoothOperatorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
SmoothOperatorAttributes::operator == (const SmoothOperatorAttributes &obj) const
{
    // Create the return value
    return ((numIterations == obj.numIterations) &&
            (relaxationFactor == obj.relaxationFactor) &&
            (convergence == obj.convergence) &&
            (maintainFeatures == obj.maintainFeatures) &&
            (featureAngle == obj.featureAngle) &&
            (edgeAngle == obj.edgeAngle) &&
            (smoothBoundaries == obj.smoothBoundaries));
}

// ****************************************************************************
// Method: SmoothOperatorAttributes::operator !=
//
// Purpose:
//   Comparison operator != for the SmoothOperatorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
SmoothOperatorAttributes::operator != (const SmoothOperatorAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: SmoothOperatorAttributes::TypeName
//
// Purpose:
//   Type name method for the SmoothOperatorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

const std::string
SmoothOperatorAttributes::TypeName() const
{
    return "SmoothOperatorAttributes";
}

// ****************************************************************************
// Method: SmoothOperatorAttributes::CopyAttributes
//
// Purpose:
//   CopyAttributes method for the SmoothOperatorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
SmoothOperatorAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const SmoothOperatorAttributes *tmp = (const SmoothOperatorAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: SmoothOperatorAttributes::CreateCompatible
//
// Purpose:
//   CreateCompatible method for the SmoothOperatorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
SmoothOperatorAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new SmoothOperatorAttributes(*this);
    // Other cases could go here too.

    return retval;
}

// ****************************************************************************
// Method: SmoothOperatorAttributes::NewInstance
//
// Purpose:
//   NewInstance method for the SmoothOperatorAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
SmoothOperatorAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new SmoothOperatorAttributes(*this);
    else
        retval = new SmoothOperatorAttributes;

    return retval;
}

// ****************************************************************************
// Method: SmoothOperatorAttributes::SelectAll
//
// Purpose:
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
SmoothOperatorAttributes::SelectAll()
{
    Select(ID_numIterations,    (void *)&numIterations);
    Select(ID_relaxationFactor, (void *)&relaxationFactor);
    Select(ID_convergence,      (void *)&convergence);
    Select(ID_maintainFeatures, (void *)&maintainFeatures);
    Select(ID_featureAngle,     (void *)&featureAngle);
    Select(ID_edgeAngle,        (void *)&edgeAngle);
    Select(ID_smoothBoundaries, (void *)&smoothBoundaries);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SmoothOperatorAttributes::CreateNode
//
// Purpose:
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
SmoothOperatorAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    SmoothOperatorAttributes defaultObject;
    bool addToParent = false;
    // Create a node for SmoothOperatorAttributes.
    DataNode *node = new DataNode("SmoothOperatorAttributes");

    if(completeSave || !FieldsEqual(ID_numIterations, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("numIterations", numIterations));
    }

    if(completeSave || !FieldsEqual(ID_relaxationFactor, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("relaxationFactor", relaxationFactor));
    }

    if(completeSave || !FieldsEqual(ID_convergence, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("convergence", convergence));
    }

    if(completeSave || !FieldsEqual(ID_maintainFeatures, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("maintainFeatures", maintainFeatures));
    }

    if(completeSave || !FieldsEqual(ID_featureAngle, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("featureAngle", featureAngle));
    }

    if(completeSave || !FieldsEqual(ID_edgeAngle, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("edgeAngle", edgeAngle));
    }

    if(completeSave || !FieldsEqual(ID_smoothBoundaries, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("smoothBoundaries", smoothBoundaries));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: SmoothOperatorAttributes::SetFromNode
//
// Purpose:
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
SmoothOperatorAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("SmoothOperatorAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("numIterations")) != 0)
        SetNumIterations(node->AsInt());
    if((node = searchNode->GetNode("relaxationFactor")) != 0)
        SetRelaxationFactor(node->AsDouble());
    if((node = searchNode->GetNode("convergence")) != 0)
        SetConvergence(node->AsDouble());
    if((node = searchNode->GetNode("maintainFeatures")) != 0)
        SetMaintainFeatures(node->AsBool());
    if((node = searchNode->GetNode("featureAngle")) != 0)
        SetFeatureAngle(node->AsDouble());
    if((node = searchNode->GetNode("edgeAngle")) != 0)
        SetEdgeAngle(node->AsDouble());
    if((node = searchNode->GetNode("smoothBoundaries")) != 0)
        SetSmoothBoundaries(node->AsBool());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
SmoothOperatorAttributes::SetNumIterations(int numIterations_)
{
    numIterations = numIterations_;
    Select(ID_numIterations, (void *)&numIterations);
}

void
SmoothOperatorAttributes::SetRelaxationFactor(double relaxationFactor_)
{
    relaxationFactor = relaxationFactor_;
    Select(ID_relaxationFactor, (void *)&relaxationFactor);
}

void
SmoothOperatorAttributes::SetConvergence(double convergence_)
{
    convergence = convergence_;
    Select(ID_convergence, (void *)&convergence);
}

void
SmoothOperatorAttributes::SetMaintainFeatures(bool maintainFeatures_)
{
    maintainFeatures = maintainFeatures_;
    Select(ID_maintainFeatures, (void *)&maintainFeatures);
}

void
SmoothOperatorAttributes::SetFeatureAngle(double featureAngle_)
{
    featureAngle = featureAngle_;
    Select(ID_featureAngle, (void *)&featureAngle);
}

void
SmoothOperatorAttributes::SetEdgeAngle(double edgeAngle_)
{
    edgeAngle = edgeAngle_;
    Select(ID_edgeAngle, (void *)&edgeAngle);
}

void
SmoothOperatorAttributes::SetSmoothBoundaries(bool smoothBoundaries_)
{
    smoothBoundaries = smoothBoundaries_;
    Select(ID_smoothBoundaries, (void *)&smoothBoundaries);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

int
SmoothOperatorAttributes::GetNumIterations() const
{
    return numIterations;
}

double
SmoothOperatorAttributes::GetRelaxationFactor() const
{
    return relaxationFactor;
}

double
SmoothOperatorAttributes::GetConvergence() const
{
    return convergence;
}

bool
SmoothOperatorAttributes::GetMaintainFeatures() const
{
    return maintainFeatures;
}

double
SmoothOperatorAttributes::GetFeatureAngle() const
{
    return featureAngle;
}

double
SmoothOperatorAttributes::GetEdgeAngle() const
{
    return edgeAngle;
}

bool
SmoothOperatorAttributes::GetSmoothBoundaries() const
{
    return smoothBoundaries;
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SmoothOperatorAttributes::GetFieldName
//
// Purpose:
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
SmoothOperatorAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_numIterations:    return "numIterations";
    case ID_relaxationFactor: return "relaxationFactor";
    case ID_convergence:      return "convergence";
    case ID_maintainFeatures: return "maintainFeatures";
    case ID_featureAngle:     return "featureAngle";
    case ID_edgeAngle:        return "edgeAngle";
    case ID_smoothBoundaries: return "smoothBoundaries";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SmoothOperatorAttributes::GetFieldType
//
// Purpose:
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeGroup::FieldType
SmoothOperatorAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_numIterations:    return FieldType_int;
    case ID_relaxationFactor: return FieldType_double;
    case ID_convergence:      return FieldType_double;
    case ID_maintainFeatures: return FieldType_bool;
    case ID_featureAngle:     return FieldType_double;
    case ID_edgeAngle:        return FieldType_double;
    case ID_smoothBoundaries: return FieldType_bool;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: SmoothOperatorAttributes::GetFieldTypeName
//
// Purpose:
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
SmoothOperatorAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_numIterations:    return "int";
    case ID_relaxationFactor: return "double";
    case ID_convergence:      return "double";
    case ID_maintainFeatures: return "bool";
    case ID_featureAngle:     return "double";
    case ID_edgeAngle:        return "double";
    case ID_smoothBoundaries: return "bool";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SmoothOperatorAttributes::FieldsEqual
//
// Purpose:
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
SmoothOperatorAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const SmoothOperatorAttributes &obj = *((const SmoothOperatorAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_numIterations:
        {  // new scope
        retval = (numIterations == obj.numIterations);
        }
        break;
    case ID_relaxationFactor:
        {  // new scope
        retval = (relaxationFactor == obj.relaxationFactor);
        }
        break;
    case ID_convergence:
        {  // new scope
        retval = (convergence == obj.convergence);
        }
        break;
    case ID_maintainFeatures:
        {  // new scope
        retval = (maintainFeatures == obj.maintainFeatures);
        }
        break;
    case ID_featureAngle:
        {  // new scope
        retval = (featureAngle == obj.featureAngle);
        }
        break;
    case ID_edgeAngle:
        {  // new scope
        retval = (edgeAngle == obj.edgeAngle);
        }
        break;
    case ID_smoothBoundaries:
        {  // new scope
        retval = (smoothBoundaries == obj.smoothBoundaries);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

