// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef QVISSMOOTHWINDOW_H
#define QVISSMOOTHWINDOW_H

#include <QvisOperatorWindow.h>
#include <AttributeSubject.h>

class SmoothOperatorAttributes;
class QLabel;
class QCheckBox;
class QLineEdit;

// ****************************************************************************
// Class: QvisSmoothWindow
//
// Purpose:
//    Defines QvisSmoothWindow class.
//
// Notes:      Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

class QvisSmoothWindow : public QvisOperatorWindow
{
    Q_OBJECT
  public:
    QvisSmoothWindow(const int type,
                         SmoothOperatorAttributes *subj,
                         const QString &caption = QString::null,
                         const QString &shortName = QString::null,
                         QvisNotepadArea *notepad = 0);
    virtual ~QvisSmoothWindow();
    virtual void CreateWindowContents();
  protected:
    void UpdateWindow(bool doAll);
    virtual void GetCurrentValues(int which_widget);
  private slots:
    void numIterationsProcessText();
    void relaxationFactorProcessText();
    void convergenceProcessText();
    void maintainFeaturesChanged(bool val);
    void featureAngleProcessText();
    void edgeAngleProcessText();
    void smoothBoundariesChanged(bool val);
  private:
    QLineEdit *numIterations;
    QLineEdit *relaxationFactor;
    QLineEdit *convergence;
    QCheckBox *maintainFeatures;
    QLineEdit *featureAngle;
    QLineEdit *edgeAngle;
    QCheckBox *smoothBoundaries;
    QLabel *numIterationsLabel;
    QLabel *relaxationFactorLabel;
    QLabel *convergenceLabel;
    QLabel *featureAngleLabel;
    QLabel *edgeAngleLabel;

    SmoothOperatorAttributes *atts;
};



#endif
