// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: SliceCommonPluginInfo.C
// ****************************************************************************

#include <SlicePluginInfo.h>
#include <SliceAttributes.h>

// ****************************************************************************
//  Method: SliceCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
SliceCommonPluginInfo::AllocAttributes()
{
    return new SliceAttributes;
}

// ****************************************************************************
//  Method: SliceCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a Slice attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
SliceCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((SliceAttributes *) to) = *((SliceAttributes *) from);
}
