// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtRevolveFilter.h
// ************************************************************************* //

#ifndef AVT_Revolve_FILTER_H
#define AVT_Revolve_FILTER_H

#include <avtPluginDataTreeIterator.h>

#include <RevolveAttributes.h>

#include <avtTypes.h>


// ****************************************************************************
//  Class: avtRevolveFilter
//
//  Purpose:
//      A plugin operator for Revolve.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Wed Dec 11 11:31:52 PDT 2002
//
//  Modifications:
//
//    Hank Childs, Sun Mar 18 10:57:33 PDT 2007
//    Add new methods to better support RZ meshes.
//
//    Eric Brugger, Thu Aug 14 09:03:55 PDT 2014
//    Modified the class to work with avtDataRepresentation.
//
// ****************************************************************************

class avtRevolveFilter : public avtPluginDataTreeIterator
{
  public:
                         avtRevolveFilter();
    virtual             ~avtRevolveFilter();

    static avtFilter    *Create();

    virtual const char  *GetType(void)  { return "avtRevolveFilter"; };
    virtual const char  *GetDescription(void)
                             { return "Revolving"; };

    virtual void         SetAtts(const AttributeGroup*);
    virtual bool         Equivalent(const AttributeGroup*);

  protected:
    RevolveAttributes   atts;

    virtual avtDataRepresentation *ExecuteData(avtDataRepresentation *);

    virtual void          UpdateDataObjectInfo(void);
    virtual void          VerifyInput(void);
    void                  RevolveExtents(double *, int);

    avtMeshCoordType      GetMeshType(void);
    void                  GetAxis(avtMeshCoordType, double *);
};


#endif
