// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  RevolveScriptingPluginInfo.C
// ************************************************************************* //
#include <PyRevolveAttributes.h>
#include <RevolvePluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(Revolve,Scripting)

// ****************************************************************************
// Method: RevolveScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
RevolveScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyRevolveAttributes_StartUp((RevolveAttributes *)subj, data);
}

// ****************************************************************************
// Method: RevolveScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
RevolveScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyRevolveAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: RevolveScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is Revolve plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
RevolveScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyRevolveAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: RevolveScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
RevolveScriptingPluginInfo::GetLogString()
{
    std::string s(PyRevolveAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: RevolveScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
RevolveScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyRevolveAttributes_SetDefaults((const RevolveAttributes *)atts);
}
