// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: RevolveCommonPluginInfo.C
// ****************************************************************************

#include <RevolvePluginInfo.h>
#include <RevolveAttributes.h>

// ****************************************************************************
//  Method: RevolveCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
RevolveCommonPluginInfo::AllocAttributes()
{
    return new RevolveAttributes;
}

// ****************************************************************************
//  Method: RevolveCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a Revolve attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
RevolveCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((RevolveAttributes *) to) = *((RevolveAttributes *) from);
}
