// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef REVOLVEATTRIBUTES_H
#define REVOLVEATTRIBUTES_H
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: RevolveAttributes
//
// Purpose:
//    This class contains attributes for the revolve operator.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class RevolveAttributes : public AttributeSubject
{
public:
    enum MeshType
    {
        Auto,
        XY,
        RZ,
        ZR
    };

    // These constructors are for objects of this class
    RevolveAttributes();
    RevolveAttributes(const RevolveAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    RevolveAttributes(private_tmfs_t tmfs);
    RevolveAttributes(const RevolveAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~RevolveAttributes();

    virtual RevolveAttributes& operator = (const RevolveAttributes &obj);
    virtual bool operator == (const RevolveAttributes &obj) const;
    virtual bool operator != (const RevolveAttributes &obj) const;
private:
    void Init();
    void Copy(const RevolveAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectAxis();

    // Property setting methods
    void SetMeshType(MeshType meshType_);
    void SetAutoAxis(bool autoAxis_);
    void SetAxis(const double *axis_);
    void SetStartAngle(double startAngle_);
    void SetStopAngle(double stopAngle_);
    void SetSteps(int steps_);

    // Property getting methods
    MeshType     GetMeshType() const;
    bool         GetAutoAxis() const;
    const double *GetAxis() const;
          double *GetAxis();
    double       GetStartAngle() const;
    double       GetStopAngle() const;
    int          GetSteps() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static std::string MeshType_ToString(MeshType);
    static bool MeshType_FromString(const std::string &, MeshType &);
protected:
    static std::string MeshType_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_meshType = 0,
        ID_autoAxis,
        ID_axis,
        ID_startAngle,
        ID_stopAngle,
        ID_steps,
        ID__LAST
    };

private:
    int    meshType;
    bool   autoAxis;
    double axis[3];
    double startAngle;
    double stopAngle;
    int    steps;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define REVOLVEATTRIBUTES_TMFS "ibDddi"

#endif
