// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include "QvisRevolveWindow.h"

#include <RevolveAttributes.h>

#include <QCheckBox>
#include <QLabel>
#include <QLayout>
#include <QLineEdit>
#include <QButtonGroup>
#include <QRadioButton>


// ****************************************************************************
// Method: QvisRevolveWindow::QvisRevolveWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisRevolveWindow::QvisRevolveWindow(const int type,
                         RevolveAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisRevolveWindow::~QvisRevolveWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisRevolveWindow::~QvisRevolveWindow()
{
}


// ****************************************************************************
// Method: QvisRevolveWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   Cyrus Harrison, Tue Aug 19 15:52:41 PDT 2008
//   Qt4 Port - Autogen + change of autoAxis checkbox to span two cols in the
//   layout.
//
// ****************************************************************************

void
QvisRevolveWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    meshTypeLabel = new QLabel(tr("Type of Mesh?"), central);
    mainLayout->addWidget(meshTypeLabel,0,0);
    QWidget *meshTypeWidget = new QWidget(central);
    meshType = new QButtonGroup(meshTypeWidget);
    QHBoxLayout *meshTypeLayout = new QHBoxLayout(meshTypeWidget);
    meshTypeLayout->setMargin(0);
    meshTypeLayout->setSpacing(10);
    QRadioButton *meshTypeMeshTypeAuto = new QRadioButton(tr("Auto"), meshTypeWidget);
    meshType->addButton(meshTypeMeshTypeAuto,0);
    meshTypeLayout->addWidget(meshTypeMeshTypeAuto);
    QRadioButton *meshTypeMeshTypeXY = new QRadioButton(tr("XY"), meshTypeWidget);
    meshType->addButton(meshTypeMeshTypeXY,1);
    meshTypeLayout->addWidget(meshTypeMeshTypeXY);
    QRadioButton *meshTypeMeshTypeRZ = new QRadioButton(tr("RZ"), meshTypeWidget);
    meshType->addButton(meshTypeMeshTypeRZ,2);
    meshTypeLayout->addWidget(meshTypeMeshTypeRZ);
    QRadioButton *meshTypeMeshTypeZR = new QRadioButton(tr("ZR"), meshTypeWidget);
    meshType->addButton(meshTypeMeshTypeZR,3);
    meshTypeLayout->addWidget(meshTypeMeshTypeZR);
    connect(meshType, SIGNAL(buttonClicked(int)),
            this, SLOT(meshTypeChanged(int)));
    mainLayout->addWidget(meshTypeWidget, 0,1);

    autoAxis = new QCheckBox(tr("Choose axis based on mesh type?"), central);
    connect(autoAxis, SIGNAL(toggled(bool)),
            this, SLOT(autoAxisChanged(bool)));
    mainLayout->addWidget(autoAxis, 1,0,1,2);

    axisLabel = new QLabel(tr("Axis of revolution"), central);
    mainLayout->addWidget(axisLabel,2,0);
    axis = new QLineEdit(central);
    connect(axis, SIGNAL(returnPressed()),
            this, SLOT(axisProcessText()));
    mainLayout->addWidget(axis, 2,1);

    startAngleLabel = new QLabel(tr("Start angle"), central);
    mainLayout->addWidget(startAngleLabel,3,0);
    startAngle = new QLineEdit(central);
    connect(startAngle, SIGNAL(returnPressed()),
            this, SLOT(startAngleProcessText()));
    mainLayout->addWidget(startAngle, 3,1);

    stopAngleLabel = new QLabel(tr("Stop angle"), central);
    mainLayout->addWidget(stopAngleLabel,4,0);
    stopAngle = new QLineEdit(central);
    connect(stopAngle, SIGNAL(returnPressed()),
            this, SLOT(stopAngleProcessText()));
    mainLayout->addWidget(stopAngle, 4,1);

    stepsLabel = new QLabel(tr("Number of steps"), central);
    mainLayout->addWidget(stepsLabel,5,0);
    steps = new QLineEdit(central);
    connect(steps, SIGNAL(returnPressed()),
            this, SLOT(stepsProcessText()));
    mainLayout->addWidget(steps, 5,1);

}


// ****************************************************************************
// Method: QvisRevolveWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisRevolveWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case RevolveAttributes::ID_meshType:
            meshType->blockSignals(true);
            if(meshType->button((int)atts->GetMeshType()) != 0)
                meshType->button((int)atts->GetMeshType())->setChecked(true);
            meshType->blockSignals(false);
            break;
          case RevolveAttributes::ID_autoAxis:
            if (atts->GetAutoAxis() == false)
            {
                axis->setEnabled(true);
                if(axisLabel)
                    axisLabel->setEnabled(true);
            }
            else
            {
                axis->setEnabled(false);
                if(axisLabel)
                    axisLabel->setEnabled(false);
            }
            autoAxis->blockSignals(true);
            autoAxis->setChecked(atts->GetAutoAxis());
            autoAxis->blockSignals(false);
            break;
          case RevolveAttributes::ID_axis:
            axis->setText(DoublesToQString(atts->GetAxis(), 3));
            break;
          case RevolveAttributes::ID_startAngle:
            startAngle->setText(DoubleToQString(atts->GetStartAngle()));
            break;
          case RevolveAttributes::ID_stopAngle:
            stopAngle->setText(DoubleToQString(atts->GetStopAngle()));
            break;
          case RevolveAttributes::ID_steps:
            steps->setText(IntToQString(atts->GetSteps()));
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisRevolveWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisRevolveWindow::GetCurrentValues(int which_widget)
{
    bool doAll = (which_widget == -1);

    // Do axis
    if(which_widget == RevolveAttributes::ID_axis || doAll)
    {
        double val[3];
        if(LineEditGetDoubles(axis, val, 3))
            atts->SetAxis(val);
        else
        {
            ResettingError(tr("Axis of revolution"),
                DoublesToQString(atts->GetAxis(),3));
            atts->SetAxis(atts->GetAxis());
        }
    }

    // Do startAngle
    if(which_widget == RevolveAttributes::ID_startAngle || doAll)
    {
        double val;
        if(LineEditGetDouble(startAngle, val))
            atts->SetStartAngle(val);
        else
        {
            ResettingError(tr("Start angle"),
                DoubleToQString(atts->GetStartAngle()));
            atts->SetStartAngle(atts->GetStartAngle());
        }
    }

    // Do stopAngle
    if(which_widget == RevolveAttributes::ID_stopAngle || doAll)
    {
        double val;
        if(LineEditGetDouble(stopAngle, val))
            atts->SetStopAngle(val);
        else
        {
            ResettingError(tr("Stop angle"),
                DoubleToQString(atts->GetStopAngle()));
            atts->SetStopAngle(atts->GetStopAngle());
        }
    }

    // Do steps
    if(which_widget == RevolveAttributes::ID_steps || doAll)
    {
        int val;
        if(LineEditGetInt(steps, val))
            atts->SetSteps(val);
        else
        {
            ResettingError(tr("Number of steps"),
                IntToQString(atts->GetSteps()));
            atts->SetSteps(atts->GetSteps());
        }
    }

}


//
// Qt Slot functions
//


void
QvisRevolveWindow::meshTypeChanged(int val)
{
    if(val != atts->GetMeshType())
    {
        atts->SetMeshType(RevolveAttributes::MeshType(val));
        SetUpdate(false);
        Apply();
    }
}


void
QvisRevolveWindow::autoAxisChanged(bool val)
{
    atts->SetAutoAxis(val);
    Apply();
}


void
QvisRevolveWindow::axisProcessText()
{
    GetCurrentValues(RevolveAttributes::ID_axis);
    Apply();
}


void
QvisRevolveWindow::startAngleProcessText()
{
    GetCurrentValues(RevolveAttributes::ID_startAngle);
    Apply();
}


void
QvisRevolveWindow::stopAngleProcessText()
{
    GetCurrentValues(RevolveAttributes::ID_stopAngle);
    Apply();
}


void
QvisRevolveWindow::stepsProcessText()
{
    GetCurrentValues(RevolveAttributes::ID_steps);
    Apply();
}


