// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtResamplePluginFilter.h
// ************************************************************************* //

#ifndef AVT_Resample_FILTER_H
#define AVT_Resample_FILTER_H


#include <avtPluginFilter.h>
#include <avtSingleFilterFacade.h>

#include <ResampleAttributes.h>

class     avtResampleFilter;

// ****************************************************************************
//  Class: avtResamplePluginFilter
//
//  Purpose:
//      A plugin operator for Resample.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sat Jan 29 10:17:24 PDT 2005
//
//  Modifications:
//
//    Hank Childs, Wed Dec 31 14:27:47 PST 2008
//    Renamed ResamplePluginAttributes to ResampleAttributes.
//
//    Tom Fogal, Tue Jun 23 20:52:29 MDT 2009
//    Added const version of GetFacadedFilter.
//
// ****************************************************************************

class avtResamplePluginFilter : virtual public avtPluginFilter,
                                virtual public avtSingleFilterFacade
{
  public:
                         avtResamplePluginFilter();
    virtual             ~avtResamplePluginFilter();

    static avtFilter    *Create();

    virtual const char  *GetType(void)  { return "avtResamplePluginFilter"; };
    virtual const char  *GetDescription(void)
                             { return "Resample"; };

    virtual void         SetAtts(const AttributeGroup*);
    virtual bool         Equivalent(const AttributeGroup*);

  protected:
    avtResampleFilter         *resampler;
    ResampleAttributes         atts;

    virtual avtFilter         *GetFacadedFilter();
    virtual const avtFilter   *GetFacadedFilter() const;

    static void UpdateDataObjectInfoCB(avtDataObject_p &input,
                                       avtDataObject_p &output, void *);
};

#endif
