// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtResamplePluginFilter.C
// ************************************************************************* //

#include <avtResamplePluginFilter.h>
#include <avtExtents.h>

#include <avtResampleFilter.h>
#include <InternalResampleAttributes.h>

// ****************************************************************************
//  Method: avtResamplePluginFilter constructor
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sat Jan 29 10:17:24 PDT 2005
//
// ****************************************************************************

avtResamplePluginFilter::avtResamplePluginFilter()
{
    resampler = NULL;
}


// ****************************************************************************
//  Method: avtResamplePluginFilter destructor
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sat Jan 29 10:17:24 PDT 2005
//
//  Modifications:
//
// ****************************************************************************

avtResamplePluginFilter::~avtResamplePluginFilter()
{
    if (resampler != NULL)
    {
        delete resampler;
        resampler = NULL;
    }
}


// ****************************************************************************
//  Method:  avtResamplePluginFilter::Create
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sat Jan 29 10:17:24 PDT 2005
//
// ****************************************************************************

avtFilter *
avtResamplePluginFilter::Create()
{
    return new avtResamplePluginFilter();
}


// ****************************************************************************
//  Method:      avtResamplePluginFilter::SetAtts
//
//  Purpose:
//      Sets the state of the filter based on the attribute object.
//
//  Arguments:
//      a        The attributes to use.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sat Jan 29 10:17:24 PDT 2005
//
//  Modifications:
//
//    Hank Childs, Fri Sep 30 09:16:06 PDT 2005
//    Add support for distributed resampling.
//
//    Sean Ahern, Wed Jan  2 16:01:48 EST 2008
//    Added support for specifying that the whole extents should be used.
//
//    Hank Childs, Wed Dec 31 13:48:13 PST 2008
//    Rename ResampleAtts to InternalResampleAtts, ResamplePluginAtts to
//    just ResampleAtts.
//
//    Brad Whitlock, Wed Mar 19 14:14:53 PDT 2014
//    Add callback to the facade filter.
//
// ****************************************************************************

void
avtResamplePluginFilter::SetAtts(const AttributeGroup *a)
{
    atts = *(const ResampleAttributes*)a;

    //
    // Construct a new resample filter based on these attributes.
    //
    if (resampler != NULL)
    {
        delete resampler;
    }

    InternalResampleAttributes res_atts;
    res_atts.SetDefaultVal(atts.GetDefaultValue());
    res_atts.SetUseTargetVal(false);
    res_atts.SetWidth(atts.GetSamplesX());
    res_atts.SetHeight(atts.GetSamplesY());
    if (atts.GetIs3D())
        res_atts.SetDepth(atts.GetSamplesZ());
    else
        res_atts.SetDepth(1);
    res_atts.SetUseBounds(!atts.GetUseExtents());
    res_atts.SetMinX(atts.GetStartX());
    res_atts.SetMaxX(atts.GetEndX());
    res_atts.SetMinY(atts.GetStartY());
    res_atts.SetMaxY(atts.GetEndY());
    if (atts.GetIs3D())
    {
        res_atts.SetMinZ(atts.GetStartZ());
        res_atts.SetMaxZ(atts.GetEndZ());
    }
    else
    {
        res_atts.SetMinZ(0);
        res_atts.SetMaxZ(0);
    }

    res_atts.SetUseArbitrator(atts.GetTieResolver() 
                           != ResampleAttributes::random);
    res_atts.SetArbitratorLessThan(atts.GetTieResolver() 
                                   != ResampleAttributes::smallest);
    res_atts.SetArbitratorVarName(atts.GetTieResolverVariable());

    res_atts.SetDistributedResample(atts.GetDistributedResample());
    resampler = new avtResampleFilter(&res_atts);
    resampler->SetUpdateDataObjectInfoCallback(UpdateDataObjectInfoCB, (void*)this);
    if (atts.GetCellCenteredOutput())
        resampler->MakeOutputCellCentered(true);
}


// ****************************************************************************
//  Method: avtResamplePluginFilter::Equivalent
//
//  Purpose:
//      Returns true if creating a new avtResamplePluginFilter with the given
//      parameters would result in an equivalent avtResamplePluginFilter.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sat Jan 29 10:17:24 PDT 2005
//
// ****************************************************************************

bool
avtResamplePluginFilter::Equivalent(const AttributeGroup *a)
{
    return (atts == *(ResampleAttributes*)a);
}


// ****************************************************************************
//  Method: avtResamplePluginFilter::GetFacadedFilter
//
//  Purpose:
//      Gets the filter that the filter that we are a facade of.
//
//  Programmer: Hank Childs
//  Creation:   January 29, 2005
//
// ****************************************************************************

avtFilter *
avtResamplePluginFilter::GetFacadedFilter(void)
{
    return resampler;
}


// ****************************************************************************
//  Method: avtResamplePluginFilter::GetFacadedFilter
//
//  Purpose:
//      Gets the filter that the filter that we are a facade of.
//
//  Programmer: Tom Fogal
//  Creation:   June 23, 2009
//
// ****************************************************************************

const avtFilter *
avtResamplePluginFilter::GetFacadedFilter(void) const
{
    return resampler;
}

// ****************************************************************************
// Method: avtResamplePluginFilter::UpdateDataObjectInfoCB
//
// Purpose:
//   Update the data object information.
//
// Note:       Work partially supported by DOE Grant SC0007548.
//
// Programmer: Brad Whitlock
// Creation:   Tue Mar 18 10:53:05 PDT 2014
//
// Modifications:
//
// ****************************************************************************

void
avtResamplePluginFilter::UpdateDataObjectInfoCB(avtDataObject_p &input,
    avtDataObject_p &output, void *This)
{
    avtDataAttributes &outAtts = output->GetInfo().GetAttributes();
    const ResampleAttributes &rs = ((const avtResamplePluginFilter *)This)->atts;

    char params[200];
    snprintf(params, 200, "nx=%d ny=%d nz=%d", 
             rs.GetSamplesX(), rs.GetSamplesY(), rs.GetSamplesZ());
    outAtts.AddFilterMetaData("Resample", params);
}
