// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  ResampleScriptingPluginInfo.C
// ************************************************************************* //
#include <PyResampleAttributes.h>
#include <ResamplePluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(Resample,Scripting)

// ****************************************************************************
// Method: ResampleScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
ResampleScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyResampleAttributes_StartUp((ResampleAttributes *)subj, data);
}

// ****************************************************************************
// Method: ResampleScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
ResampleScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyResampleAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: ResampleScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is Resample plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
ResampleScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyResampleAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: ResampleScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
ResampleScriptingPluginInfo::GetLogString()
{
    std::string s(PyResampleAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: ResampleScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
ResampleScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyResampleAttributes_SetDefaults((const ResampleAttributes *)atts);
}
