// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ReplicatePluginInfo.h
// ****************************************************************************

#ifndef REPLICATE_PLUGIN_INFO_H
#define REPLICATE_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class ReplicateAttributes;

// ****************************************************************************
//  Class: ReplicatePluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an Replicate operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class ReplicateGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class ReplicateCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual ReplicateGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class ReplicateGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual ReplicateCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
    virtual const char **XPMIconData() const;
};

class ReplicateViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual ReplicateCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;

    static void InitializeGlobalObjects();
  private:
    static ReplicateAttributes *defaultAtts;
    static ReplicateAttributes *clientAtts;
};

class ReplicateViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual ReplicateViewerEnginePluginInfo
{
  public:
    virtual const char **XPMIconData() const;
};

class ReplicateEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual ReplicateViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class ReplicateScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual ReplicateCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
