// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ReplicateCommonPluginInfo.C
// ****************************************************************************

#include <ReplicatePluginInfo.h>
#include <ReplicateAttributes.h>

// ****************************************************************************
//  Method: ReplicateCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
ReplicateCommonPluginInfo::AllocAttributes()
{
    return new ReplicateAttributes;
}

// ****************************************************************************
//  Method: ReplicateCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a Replicate attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ReplicateCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((ReplicateAttributes *) to) = *((ReplicateAttributes *) from);
}
