// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef QVISREPLICATEWINDOW_H
#define QVISREPLICATEWINDOW_H

#include <QvisOperatorWindow.h>
#include <AttributeSubject.h>

class ReplicateAttributes;
class QLabel;
class QCheckBox;
class QLineEdit;

// ****************************************************************************
// Class: QvisReplicateWindow
//
// Purpose:
//    Defines QvisReplicateWindow class.
//
// Notes:      Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//    Jeremy Meredith, Tue Jun  2 16:25:01 EDT 2009
//    Added support for shifting atoms to a new unit cell origin.
//
//   
// ****************************************************************************

class QvisReplicateWindow : public QvisOperatorWindow
{
    Q_OBJECT
  public:
    QvisReplicateWindow(const int type,
                         ReplicateAttributes *subj,
                         const QString &caption = QString::null,
                         const QString &shortName = QString::null,
                         QvisNotepadArea *notepad = 0);
    virtual ~QvisReplicateWindow();
    virtual void CreateWindowContents();
  protected:
    void UpdateWindow(bool doAll);
    virtual void GetCurrentValues(int which_widget);
  private slots:
    void useUnitCellVectorsChanged(bool val);
    void xVectorProcessText();
    void yVectorProcessText();
    void zVectorProcessText();
    void xReplicationsProcessText();
    void yReplicationsProcessText();
    void zReplicationsProcessText();
    void mergeResultsChanged(bool val);
    void replicateUnitCellAtomsChanged(bool val);
    void shiftPeriodicAtomOriginChanged(bool val);
    void newPeriodicOriginProcessText();
  private:
    QCheckBox *useUnitCellVectors;
    QLineEdit *xVector;
    QLineEdit *yVector;
    QLineEdit *zVector;
    QLineEdit *xReplications;
    QLineEdit *yReplications;
    QLineEdit *zReplications;
    QCheckBox *mergeResults;
    QCheckBox *replicateUnitCellAtoms;
    QCheckBox *shiftPeriodicAtomOrigin;
    QLineEdit *newPeriodicOrigin;
    QLabel *useUnitCellVectorsLabel;
    QLabel *xVectorLabel;
    QLabel *yVectorLabel;
    QLabel *zVectorLabel;
    QLabel *xReplicationsLabel;
    QLabel *yReplicationsLabel;
    QLabel *zReplicationsLabel;
    QLabel *newPeriodicOriginLabel;

    ReplicateAttributes *atts;
};



#endif
