// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PyReplicateAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>

// ****************************************************************************
// Module: PyReplicateAttributes
//
// Purpose:
//   This class contains attributes for the replicate operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a ReplicateAttributes.
//
struct ReplicateAttributesObject
{
    PyObject_HEAD
    ReplicateAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewReplicateAttributes(int);

std::string
PyReplicateAttributes_ToString(const ReplicateAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    if(atts->GetUseUnitCellVectors())
        snprintf(tmpStr, 1000, "%suseUnitCellVectors = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%suseUnitCellVectors = 0\n", prefix);
    str += tmpStr;
    {   const double *xVector = atts->GetXVector();
        snprintf(tmpStr, 1000, "%sxVector = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            snprintf(tmpStr, 1000, "%g", xVector[i]);
            str += tmpStr;
            if(i < 2)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *yVector = atts->GetYVector();
        snprintf(tmpStr, 1000, "%syVector = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            snprintf(tmpStr, 1000, "%g", yVector[i]);
            str += tmpStr;
            if(i < 2)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *zVector = atts->GetZVector();
        snprintf(tmpStr, 1000, "%szVector = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            snprintf(tmpStr, 1000, "%g", zVector[i]);
            str += tmpStr;
            if(i < 2)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    snprintf(tmpStr, 1000, "%sxReplications = %d\n", prefix, atts->GetXReplications());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%syReplications = %d\n", prefix, atts->GetYReplications());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%szReplications = %d\n", prefix, atts->GetZReplications());
    str += tmpStr;
    if(atts->GetMergeResults())
        snprintf(tmpStr, 1000, "%smergeResults = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%smergeResults = 0\n", prefix);
    str += tmpStr;
    if(atts->GetReplicateUnitCellAtoms())
        snprintf(tmpStr, 1000, "%sreplicateUnitCellAtoms = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sreplicateUnitCellAtoms = 0\n", prefix);
    str += tmpStr;
    if(atts->GetShiftPeriodicAtomOrigin())
        snprintf(tmpStr, 1000, "%sshiftPeriodicAtomOrigin = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sshiftPeriodicAtomOrigin = 0\n", prefix);
    str += tmpStr;
    {   const double *newPeriodicOrigin = atts->GetNewPeriodicOrigin();
        snprintf(tmpStr, 1000, "%snewPeriodicOrigin = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            snprintf(tmpStr, 1000, "%g", newPeriodicOrigin[i]);
            str += tmpStr;
            if(i < 2)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    return str;
}

static PyObject *
ReplicateAttributes_Notify(PyObject *self, PyObject *args)
{
    ReplicateAttributesObject *obj = (ReplicateAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ReplicateAttributes_SetUseUnitCellVectors(PyObject *self, PyObject *args)
{
    ReplicateAttributesObject *obj = (ReplicateAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useUnitCellVectors in the object.
    obj->data->SetUseUnitCellVectors(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ReplicateAttributes_GetUseUnitCellVectors(PyObject *self, PyObject *args)
{
    ReplicateAttributesObject *obj = (ReplicateAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseUnitCellVectors()?1L:0L);
    return retval;
}

/*static*/ PyObject *
ReplicateAttributes_SetXVector(PyObject *self, PyObject *args)
{
    ReplicateAttributesObject *obj = (ReplicateAttributesObject *)self;

    double *dvals = obj->data->GetXVector();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the xVector in the object as modified.
    obj->data->SelectXVector();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ReplicateAttributes_GetXVector(PyObject *self, PyObject *args)
{
    ReplicateAttributesObject *obj = (ReplicateAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the xVector.
    PyObject *retval = PyTuple_New(3);
    const double *xVector = obj->data->GetXVector();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(xVector[i]));
    return retval;
}

/*static*/ PyObject *
ReplicateAttributes_SetYVector(PyObject *self, PyObject *args)
{
    ReplicateAttributesObject *obj = (ReplicateAttributesObject *)self;

    double *dvals = obj->data->GetYVector();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the yVector in the object as modified.
    obj->data->SelectYVector();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ReplicateAttributes_GetYVector(PyObject *self, PyObject *args)
{
    ReplicateAttributesObject *obj = (ReplicateAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the yVector.
    PyObject *retval = PyTuple_New(3);
    const double *yVector = obj->data->GetYVector();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(yVector[i]));
    return retval;
}

/*static*/ PyObject *
ReplicateAttributes_SetZVector(PyObject *self, PyObject *args)
{
    ReplicateAttributesObject *obj = (ReplicateAttributesObject *)self;

    double *dvals = obj->data->GetZVector();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the zVector in the object as modified.
    obj->data->SelectZVector();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ReplicateAttributes_GetZVector(PyObject *self, PyObject *args)
{
    ReplicateAttributesObject *obj = (ReplicateAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the zVector.
    PyObject *retval = PyTuple_New(3);
    const double *zVector = obj->data->GetZVector();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(zVector[i]));
    return retval;
}

/*static*/ PyObject *
ReplicateAttributes_SetXReplications(PyObject *self, PyObject *args)
{
    ReplicateAttributesObject *obj = (ReplicateAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the xReplications in the object.
    obj->data->SetXReplications((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ReplicateAttributes_GetXReplications(PyObject *self, PyObject *args)
{
    ReplicateAttributesObject *obj = (ReplicateAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetXReplications()));
    return retval;
}

/*static*/ PyObject *
ReplicateAttributes_SetYReplications(PyObject *self, PyObject *args)
{
    ReplicateAttributesObject *obj = (ReplicateAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the yReplications in the object.
    obj->data->SetYReplications((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ReplicateAttributes_GetYReplications(PyObject *self, PyObject *args)
{
    ReplicateAttributesObject *obj = (ReplicateAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetYReplications()));
    return retval;
}

/*static*/ PyObject *
ReplicateAttributes_SetZReplications(PyObject *self, PyObject *args)
{
    ReplicateAttributesObject *obj = (ReplicateAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the zReplications in the object.
    obj->data->SetZReplications((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ReplicateAttributes_GetZReplications(PyObject *self, PyObject *args)
{
    ReplicateAttributesObject *obj = (ReplicateAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetZReplications()));
    return retval;
}

/*static*/ PyObject *
ReplicateAttributes_SetMergeResults(PyObject *self, PyObject *args)
{
    ReplicateAttributesObject *obj = (ReplicateAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the mergeResults in the object.
    obj->data->SetMergeResults(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ReplicateAttributes_GetMergeResults(PyObject *self, PyObject *args)
{
    ReplicateAttributesObject *obj = (ReplicateAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetMergeResults()?1L:0L);
    return retval;
}

/*static*/ PyObject *
ReplicateAttributes_SetReplicateUnitCellAtoms(PyObject *self, PyObject *args)
{
    ReplicateAttributesObject *obj = (ReplicateAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the replicateUnitCellAtoms in the object.
    obj->data->SetReplicateUnitCellAtoms(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ReplicateAttributes_GetReplicateUnitCellAtoms(PyObject *self, PyObject *args)
{
    ReplicateAttributesObject *obj = (ReplicateAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetReplicateUnitCellAtoms()?1L:0L);
    return retval;
}

/*static*/ PyObject *
ReplicateAttributes_SetShiftPeriodicAtomOrigin(PyObject *self, PyObject *args)
{
    ReplicateAttributesObject *obj = (ReplicateAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the shiftPeriodicAtomOrigin in the object.
    obj->data->SetShiftPeriodicAtomOrigin(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ReplicateAttributes_GetShiftPeriodicAtomOrigin(PyObject *self, PyObject *args)
{
    ReplicateAttributesObject *obj = (ReplicateAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShiftPeriodicAtomOrigin()?1L:0L);
    return retval;
}

/*static*/ PyObject *
ReplicateAttributes_SetNewPeriodicOrigin(PyObject *self, PyObject *args)
{
    ReplicateAttributesObject *obj = (ReplicateAttributesObject *)self;

    double *dvals = obj->data->GetNewPeriodicOrigin();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the newPeriodicOrigin in the object as modified.
    obj->data->SelectNewPeriodicOrigin();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ReplicateAttributes_GetNewPeriodicOrigin(PyObject *self, PyObject *args)
{
    ReplicateAttributesObject *obj = (ReplicateAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the newPeriodicOrigin.
    PyObject *retval = PyTuple_New(3);
    const double *newPeriodicOrigin = obj->data->GetNewPeriodicOrigin();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(newPeriodicOrigin[i]));
    return retval;
}



PyMethodDef PyReplicateAttributes_methods[REPLICATEATTRIBUTES_NMETH] = {
    {"Notify", ReplicateAttributes_Notify, METH_VARARGS},
    {"SetUseUnitCellVectors", ReplicateAttributes_SetUseUnitCellVectors, METH_VARARGS},
    {"GetUseUnitCellVectors", ReplicateAttributes_GetUseUnitCellVectors, METH_VARARGS},
    {"SetXVector", ReplicateAttributes_SetXVector, METH_VARARGS},
    {"GetXVector", ReplicateAttributes_GetXVector, METH_VARARGS},
    {"SetYVector", ReplicateAttributes_SetYVector, METH_VARARGS},
    {"GetYVector", ReplicateAttributes_GetYVector, METH_VARARGS},
    {"SetZVector", ReplicateAttributes_SetZVector, METH_VARARGS},
    {"GetZVector", ReplicateAttributes_GetZVector, METH_VARARGS},
    {"SetXReplications", ReplicateAttributes_SetXReplications, METH_VARARGS},
    {"GetXReplications", ReplicateAttributes_GetXReplications, METH_VARARGS},
    {"SetYReplications", ReplicateAttributes_SetYReplications, METH_VARARGS},
    {"GetYReplications", ReplicateAttributes_GetYReplications, METH_VARARGS},
    {"SetZReplications", ReplicateAttributes_SetZReplications, METH_VARARGS},
    {"GetZReplications", ReplicateAttributes_GetZReplications, METH_VARARGS},
    {"SetMergeResults", ReplicateAttributes_SetMergeResults, METH_VARARGS},
    {"GetMergeResults", ReplicateAttributes_GetMergeResults, METH_VARARGS},
    {"SetReplicateUnitCellAtoms", ReplicateAttributes_SetReplicateUnitCellAtoms, METH_VARARGS},
    {"GetReplicateUnitCellAtoms", ReplicateAttributes_GetReplicateUnitCellAtoms, METH_VARARGS},
    {"SetShiftPeriodicAtomOrigin", ReplicateAttributes_SetShiftPeriodicAtomOrigin, METH_VARARGS},
    {"GetShiftPeriodicAtomOrigin", ReplicateAttributes_GetShiftPeriodicAtomOrigin, METH_VARARGS},
    {"SetNewPeriodicOrigin", ReplicateAttributes_SetNewPeriodicOrigin, METH_VARARGS},
    {"GetNewPeriodicOrigin", ReplicateAttributes_GetNewPeriodicOrigin, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ReplicateAttributes_dealloc(PyObject *v)
{
   ReplicateAttributesObject *obj = (ReplicateAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
ReplicateAttributes_compare(PyObject *v, PyObject *w)
{
    ReplicateAttributes *a = ((ReplicateAttributesObject *)v)->data;
    ReplicateAttributes *b = ((ReplicateAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyReplicateAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "useUnitCellVectors") == 0)
        return ReplicateAttributes_GetUseUnitCellVectors(self, NULL);
    if(strcmp(name, "xVector") == 0)
        return ReplicateAttributes_GetXVector(self, NULL);
    if(strcmp(name, "yVector") == 0)
        return ReplicateAttributes_GetYVector(self, NULL);
    if(strcmp(name, "zVector") == 0)
        return ReplicateAttributes_GetZVector(self, NULL);
    if(strcmp(name, "xReplications") == 0)
        return ReplicateAttributes_GetXReplications(self, NULL);
    if(strcmp(name, "yReplications") == 0)
        return ReplicateAttributes_GetYReplications(self, NULL);
    if(strcmp(name, "zReplications") == 0)
        return ReplicateAttributes_GetZReplications(self, NULL);
    if(strcmp(name, "mergeResults") == 0)
        return ReplicateAttributes_GetMergeResults(self, NULL);
    if(strcmp(name, "replicateUnitCellAtoms") == 0)
        return ReplicateAttributes_GetReplicateUnitCellAtoms(self, NULL);
    if(strcmp(name, "shiftPeriodicAtomOrigin") == 0)
        return ReplicateAttributes_GetShiftPeriodicAtomOrigin(self, NULL);
    if(strcmp(name, "newPeriodicOrigin") == 0)
        return ReplicateAttributes_GetNewPeriodicOrigin(self, NULL);

    return Py_FindMethod(PyReplicateAttributes_methods, self, name);
}

int
PyReplicateAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "useUnitCellVectors") == 0)
        obj = ReplicateAttributes_SetUseUnitCellVectors(self, tuple);
    else if(strcmp(name, "xVector") == 0)
        obj = ReplicateAttributes_SetXVector(self, tuple);
    else if(strcmp(name, "yVector") == 0)
        obj = ReplicateAttributes_SetYVector(self, tuple);
    else if(strcmp(name, "zVector") == 0)
        obj = ReplicateAttributes_SetZVector(self, tuple);
    else if(strcmp(name, "xReplications") == 0)
        obj = ReplicateAttributes_SetXReplications(self, tuple);
    else if(strcmp(name, "yReplications") == 0)
        obj = ReplicateAttributes_SetYReplications(self, tuple);
    else if(strcmp(name, "zReplications") == 0)
        obj = ReplicateAttributes_SetZReplications(self, tuple);
    else if(strcmp(name, "mergeResults") == 0)
        obj = ReplicateAttributes_SetMergeResults(self, tuple);
    else if(strcmp(name, "replicateUnitCellAtoms") == 0)
        obj = ReplicateAttributes_SetReplicateUnitCellAtoms(self, tuple);
    else if(strcmp(name, "shiftPeriodicAtomOrigin") == 0)
        obj = ReplicateAttributes_SetShiftPeriodicAtomOrigin(self, tuple);
    else if(strcmp(name, "newPeriodicOrigin") == 0)
        obj = ReplicateAttributes_SetNewPeriodicOrigin(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
ReplicateAttributes_print(PyObject *v, FILE *fp, int flags)
{
    ReplicateAttributesObject *obj = (ReplicateAttributesObject *)v;
    fprintf(fp, "%s", PyReplicateAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
ReplicateAttributes_str(PyObject *v)
{
    ReplicateAttributesObject *obj = (ReplicateAttributesObject *)v;
    return PyString_FromString(PyReplicateAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *ReplicateAttributes_Purpose = "This class contains attributes for the replicate operator.";
#else
static char *ReplicateAttributes_Purpose = "This class contains attributes for the replicate operator.";
#endif

//
// The type description structure
//
static PyTypeObject ReplicateAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ReplicateAttributes",                    // tp_name
    sizeof(ReplicateAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ReplicateAttributes_dealloc,  // tp_dealloc
    (printfunc)ReplicateAttributes_print,     // tp_print
    (getattrfunc)PyReplicateAttributes_getattr, // tp_getattr
    (setattrfunc)PyReplicateAttributes_setattr, // tp_setattr
    (cmpfunc)ReplicateAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)ReplicateAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ReplicateAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ReplicateAttributes *defaultAtts = 0;
static ReplicateAttributes *currentAtts = 0;

static PyObject *
NewReplicateAttributes(int useCurrent)
{
    ReplicateAttributesObject *newObject;
    newObject = PyObject_NEW(ReplicateAttributesObject, &ReplicateAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new ReplicateAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new ReplicateAttributes(*defaultAtts);
    else
        newObject->data = new ReplicateAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapReplicateAttributes(const ReplicateAttributes *attr)
{
    ReplicateAttributesObject *newObject;
    newObject = PyObject_NEW(ReplicateAttributesObject, &ReplicateAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ReplicateAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ReplicateAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewReplicateAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ReplicateAttributesMethods[] = {
    {"ReplicateAttributes", ReplicateAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ReplicateAttributesObserver = 0;

std::string
PyReplicateAttributes_GetLogString()
{
    std::string s("ReplicateAtts = ReplicateAttributes()\n");
    if(currentAtts != 0)
        s += PyReplicateAttributes_ToString(currentAtts, "ReplicateAtts.");
    return s;
}

static void
PyReplicateAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("ReplicateAtts = ReplicateAttributes()\n");
        s += PyReplicateAttributes_ToString(currentAtts, "ReplicateAtts.");
        cb(s);
    }
}

void
PyReplicateAttributes_StartUp(ReplicateAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyReplicateAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ReplicateAttributesObserver == 0)
    {
        ReplicateAttributesObserver = new ObserverToCallback(subj,
            PyReplicateAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyReplicateAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ReplicateAttributesObserver;
    ReplicateAttributesObserver = 0;
}

PyMethodDef *
PyReplicateAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ReplicateAttributesMethods;
}

bool
PyReplicateAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &ReplicateAttributesType);
}

ReplicateAttributes *
PyReplicateAttributes_FromPyObject(PyObject *obj)
{
    ReplicateAttributesObject *obj2 = (ReplicateAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyReplicateAttributes_New()
{
    return NewReplicateAttributes(0);
}

PyObject *
PyReplicateAttributes_Wrap(const ReplicateAttributes *attr)
{
    return WrapReplicateAttributes(attr);
}

void
PyReplicateAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    ReplicateAttributesObject *obj2 = (ReplicateAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyReplicateAttributes_SetDefaults(const ReplicateAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ReplicateAttributes(*atts);
}

