// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: RemoveCellsPluginInfo.C
// ****************************************************************************

#include <RemoveCellsPluginInfo.h>
#include <RemoveCellsAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(RemoveCells,OP_EXPORT)

VISIT_OPERATOR_PLUGIN_ENTRY(RemoveCells,General)

// ****************************************************************************
//  Method: RemoveCellsGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the operator plugin.
//
//  Returns:    A pointer to the name of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
RemoveCellsGeneralPluginInfo::GetName() const
{
    return "RemoveCells";
}

// ****************************************************************************
//  Method: RemoveCellsGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the operator plugin.
//
//  Returns:    A pointer to the version of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
RemoveCellsGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: RemoveCellsGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the operator plugin.
//
//  Returns:    A pointer to the id of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
RemoveCellsGeneralPluginInfo::GetID() const
{
    return "RemoveCells_1.0";
}
// ****************************************************************************
//  Method: RemoveCellsGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
RemoveCellsGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}

// ****************************************************************************
//  Method: RemoveCellsGeneralPluginInfo::GetCategoryName
//
//  Purpose:
//    Return the category name to which the operator belongs.
//
//  Returns:    Return the category name to which the operator belongs.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
RemoveCellsGeneralPluginInfo::GetCategoryName() const
{
    return "Selection";
}
