// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <RemoveCellsAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: RemoveCellsAttributes::RemoveCellsAttributes
//
// Purpose:
//   Init utility for the RemoveCellsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void RemoveCellsAttributes::Init()
{

    RemoveCellsAttributes::SelectAll();
}

// ****************************************************************************
// Method: RemoveCellsAttributes::RemoveCellsAttributes
//
// Purpose:
//   Copy utility for the RemoveCellsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void RemoveCellsAttributes::Copy(const RemoveCellsAttributes &obj)
{
    cellList = obj.cellList;
    domainList = obj.domainList;

    RemoveCellsAttributes::SelectAll();
}

// Type map format string
const char *RemoveCellsAttributes::TypeMapFormatString = REMOVECELLSATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t RemoveCellsAttributes::TmfsStruct = {REMOVECELLSATTRIBUTES_TMFS};


// ****************************************************************************
// Method: RemoveCellsAttributes::RemoveCellsAttributes
//
// Purpose:
//   Default constructor for the RemoveCellsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

RemoveCellsAttributes::RemoveCellsAttributes() :
    AttributeSubject(RemoveCellsAttributes::TypeMapFormatString)
{
    RemoveCellsAttributes::Init();
}

// ****************************************************************************
// Method: RemoveCellsAttributes::RemoveCellsAttributes
//
// Purpose:
//   Constructor for the derived classes of RemoveCellsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

RemoveCellsAttributes::RemoveCellsAttributes(private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    RemoveCellsAttributes::Init();
}

// ****************************************************************************
// Method: RemoveCellsAttributes::RemoveCellsAttributes
//
// Purpose:
//   Copy constructor for the RemoveCellsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

RemoveCellsAttributes::RemoveCellsAttributes(const RemoveCellsAttributes &obj) :
    AttributeSubject(RemoveCellsAttributes::TypeMapFormatString)
{
    RemoveCellsAttributes::Copy(obj);
}

// ****************************************************************************
// Method: RemoveCellsAttributes::RemoveCellsAttributes
//
// Purpose:
//   Copy constructor for derived classes of the RemoveCellsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

RemoveCellsAttributes::RemoveCellsAttributes(const RemoveCellsAttributes &obj, private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    RemoveCellsAttributes::Copy(obj);
}

// ****************************************************************************
// Method: RemoveCellsAttributes::~RemoveCellsAttributes
//
// Purpose:
//   Destructor for the RemoveCellsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

RemoveCellsAttributes::~RemoveCellsAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: RemoveCellsAttributes::operator =
//
// Purpose:
//   Assignment operator for the RemoveCellsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

RemoveCellsAttributes&
RemoveCellsAttributes::operator = (const RemoveCellsAttributes &obj)
{
    if (this == &obj) return *this;

    RemoveCellsAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: RemoveCellsAttributes::operator ==
//
// Purpose:
//   Comparison operator == for the RemoveCellsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
RemoveCellsAttributes::operator == (const RemoveCellsAttributes &obj) const
{
    // Create the return value
    return ((cellList == obj.cellList) &&
            (domainList == obj.domainList));
}

// ****************************************************************************
// Method: RemoveCellsAttributes::operator !=
//
// Purpose:
//   Comparison operator != for the RemoveCellsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
RemoveCellsAttributes::operator != (const RemoveCellsAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: RemoveCellsAttributes::TypeName
//
// Purpose:
//   Type name method for the RemoveCellsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

const std::string
RemoveCellsAttributes::TypeName() const
{
    return "RemoveCellsAttributes";
}

// ****************************************************************************
// Method: RemoveCellsAttributes::CopyAttributes
//
// Purpose:
//   CopyAttributes method for the RemoveCellsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
RemoveCellsAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const RemoveCellsAttributes *tmp = (const RemoveCellsAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: RemoveCellsAttributes::CreateCompatible
//
// Purpose:
//   CreateCompatible method for the RemoveCellsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
RemoveCellsAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new RemoveCellsAttributes(*this);
    // Other cases could go here too.

    return retval;
}

// ****************************************************************************
// Method: RemoveCellsAttributes::NewInstance
//
// Purpose:
//   NewInstance method for the RemoveCellsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
RemoveCellsAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new RemoveCellsAttributes(*this);
    else
        retval = new RemoveCellsAttributes;

    return retval;
}

// ****************************************************************************
// Method: RemoveCellsAttributes::SelectAll
//
// Purpose:
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
RemoveCellsAttributes::SelectAll()
{
    Select(ID_cellList,   (void *)&cellList);
    Select(ID_domainList, (void *)&domainList);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: RemoveCellsAttributes::CreateNode
//
// Purpose:
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
RemoveCellsAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    RemoveCellsAttributes defaultObject;
    bool addToParent = false;
    // Create a node for RemoveCellsAttributes.
    DataNode *node = new DataNode("RemoveCellsAttributes");

    if(completeSave || !FieldsEqual(ID_cellList, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("cellList", cellList));
    }

    if(completeSave || !FieldsEqual(ID_domainList, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("domainList", domainList));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: RemoveCellsAttributes::SetFromNode
//
// Purpose:
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
RemoveCellsAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("RemoveCellsAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("cellList")) != 0)
        SetCellList(node->AsIntVector());
    if((node = searchNode->GetNode("domainList")) != 0)
        SetDomainList(node->AsIntVector());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
RemoveCellsAttributes::SetCellList(const intVector &cellList_)
{
    cellList = cellList_;
    Select(ID_cellList, (void *)&cellList);
}

void
RemoveCellsAttributes::SetDomainList(const intVector &domainList_)
{
    domainList = domainList_;
    Select(ID_domainList, (void *)&domainList);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const intVector &
RemoveCellsAttributes::GetCellList() const
{
    return cellList;
}

intVector &
RemoveCellsAttributes::GetCellList()
{
    return cellList;
}

const intVector &
RemoveCellsAttributes::GetDomainList() const
{
    return domainList;
}

intVector &
RemoveCellsAttributes::GetDomainList()
{
    return domainList;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
RemoveCellsAttributes::SelectCellList()
{
    Select(ID_cellList, (void *)&cellList);
}

void
RemoveCellsAttributes::SelectDomainList()
{
    Select(ID_domainList, (void *)&domainList);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: RemoveCellsAttributes::GetFieldName
//
// Purpose:
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
RemoveCellsAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_cellList:   return "cellList";
    case ID_domainList: return "domainList";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: RemoveCellsAttributes::GetFieldType
//
// Purpose:
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeGroup::FieldType
RemoveCellsAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_cellList:   return FieldType_intVector;
    case ID_domainList: return FieldType_intVector;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: RemoveCellsAttributes::GetFieldTypeName
//
// Purpose:
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
RemoveCellsAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_cellList:   return "intVector";
    case ID_domainList: return "intVector";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: RemoveCellsAttributes::FieldsEqual
//
// Purpose:
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
RemoveCellsAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const RemoveCellsAttributes &obj = *((const RemoveCellsAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_cellList:
        {  // new scope
        retval = (cellList == obj.cellList);
        }
        break;
    case ID_domainList:
        {  // new scope
        retval = (domainList == obj.domainList);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

