// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit.operators;

import llnl.visit.AttributeSubject;
import llnl.visit.CommunicationBuffer;
import llnl.visit.Plugin;

// ****************************************************************************
// Class: RemapAttributes
//
// Purpose:
//    Atts for Remap operator
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class RemapAttributes extends AttributeSubject implements Plugin
{
    private static int RemapAttributes_numAdditionalAtts = 12;

    // Enum values
    public final static int VARIABLETYPES_INTRINSIC = 0;
    public final static int VARIABLETYPES_EXTRINSIC = 1;


    public RemapAttributes()
    {
        super(RemapAttributes_numAdditionalAtts);

        useExtents = true;
        startX = 0;
        endX = 1;
        cellsX = 10;
        startY = 0;
        endY = 1;
        cellsY = 10;
        is3D = true;
        startZ = 0;
        endZ = 1;
        cellsZ = 10;
        variableType = VARIABLETYPES_INTRINSIC;
    }

    public RemapAttributes(int nMoreFields)
    {
        super(RemapAttributes_numAdditionalAtts + nMoreFields);

        useExtents = true;
        startX = 0;
        endX = 1;
        cellsX = 10;
        startY = 0;
        endY = 1;
        cellsY = 10;
        is3D = true;
        startZ = 0;
        endZ = 1;
        cellsZ = 10;
        variableType = VARIABLETYPES_INTRINSIC;
    }

    public RemapAttributes(RemapAttributes obj)
    {
        super(obj);

        useExtents = obj.useExtents;
        startX = obj.startX;
        endX = obj.endX;
        cellsX = obj.cellsX;
        startY = obj.startY;
        endY = obj.endY;
        cellsY = obj.cellsY;
        is3D = obj.is3D;
        startZ = obj.startZ;
        endZ = obj.endZ;
        cellsZ = obj.cellsZ;
        variableType = obj.variableType;

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return RemapAttributes_numAdditionalAtts;
    }

    public boolean equals(RemapAttributes obj)
    {
        // Create the return value
        return ((useExtents == obj.useExtents) &&
                (startX == obj.startX) &&
                (endX == obj.endX) &&
                (cellsX == obj.cellsX) &&
                (startY == obj.startY) &&
                (endY == obj.endY) &&
                (cellsY == obj.cellsY) &&
                (is3D == obj.is3D) &&
                (startZ == obj.startZ) &&
                (endZ == obj.endZ) &&
                (cellsZ == obj.cellsZ) &&
                (variableType == obj.variableType));
    }

    public String GetName() { return "Remap"; }
    public String GetVersion() { return "1.0"; }

    // Property setting methods
    public void SetUseExtents(boolean useExtents_)
    {
        useExtents = useExtents_;
        Select(0);
    }

    public void SetStartX(double startX_)
    {
        startX = startX_;
        Select(1);
    }

    public void SetEndX(double endX_)
    {
        endX = endX_;
        Select(2);
    }

    public void SetCellsX(int cellsX_)
    {
        cellsX = cellsX_;
        Select(3);
    }

    public void SetStartY(double startY_)
    {
        startY = startY_;
        Select(4);
    }

    public void SetEndY(double endY_)
    {
        endY = endY_;
        Select(5);
    }

    public void SetCellsY(int cellsY_)
    {
        cellsY = cellsY_;
        Select(6);
    }

    public void SetIs3D(boolean is3D_)
    {
        is3D = is3D_;
        Select(7);
    }

    public void SetStartZ(double startZ_)
    {
        startZ = startZ_;
        Select(8);
    }

    public void SetEndZ(double endZ_)
    {
        endZ = endZ_;
        Select(9);
    }

    public void SetCellsZ(int cellsZ_)
    {
        cellsZ = cellsZ_;
        Select(10);
    }

    public void SetVariableType(int variableType_)
    {
        variableType = variableType_;
        Select(11);
    }

    // Property getting methods
    public boolean GetUseExtents() { return useExtents; }
    public double  GetStartX() { return startX; }
    public double  GetEndX() { return endX; }
    public int     GetCellsX() { return cellsX; }
    public double  GetStartY() { return startY; }
    public double  GetEndY() { return endY; }
    public int     GetCellsY() { return cellsY; }
    public boolean GetIs3D() { return is3D; }
    public double  GetStartZ() { return startZ; }
    public double  GetEndZ() { return endZ; }
    public int     GetCellsZ() { return cellsZ; }
    public int     GetVariableType() { return variableType; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteBool(useExtents);
        if(WriteSelect(1, buf))
            buf.WriteDouble(startX);
        if(WriteSelect(2, buf))
            buf.WriteDouble(endX);
        if(WriteSelect(3, buf))
            buf.WriteInt(cellsX);
        if(WriteSelect(4, buf))
            buf.WriteDouble(startY);
        if(WriteSelect(5, buf))
            buf.WriteDouble(endY);
        if(WriteSelect(6, buf))
            buf.WriteInt(cellsY);
        if(WriteSelect(7, buf))
            buf.WriteBool(is3D);
        if(WriteSelect(8, buf))
            buf.WriteDouble(startZ);
        if(WriteSelect(9, buf))
            buf.WriteDouble(endZ);
        if(WriteSelect(10, buf))
            buf.WriteInt(cellsZ);
        if(WriteSelect(11, buf))
            buf.WriteInt(variableType);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        switch(index)
        {
        case 0:
            SetUseExtents(buf.ReadBool());
            break;
        case 1:
            SetStartX(buf.ReadDouble());
            break;
        case 2:
            SetEndX(buf.ReadDouble());
            break;
        case 3:
            SetCellsX(buf.ReadInt());
            break;
        case 4:
            SetStartY(buf.ReadDouble());
            break;
        case 5:
            SetEndY(buf.ReadDouble());
            break;
        case 6:
            SetCellsY(buf.ReadInt());
            break;
        case 7:
            SetIs3D(buf.ReadBool());
            break;
        case 8:
            SetStartZ(buf.ReadDouble());
            break;
        case 9:
            SetEndZ(buf.ReadDouble());
            break;
        case 10:
            SetCellsZ(buf.ReadInt());
            break;
        case 11:
            SetVariableType(buf.ReadInt());
            break;
        }
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + boolToString("useExtents", useExtents, indent) + "\n";
        str = str + doubleToString("startX", startX, indent) + "\n";
        str = str + doubleToString("endX", endX, indent) + "\n";
        str = str + intToString("cellsX", cellsX, indent) + "\n";
        str = str + doubleToString("startY", startY, indent) + "\n";
        str = str + doubleToString("endY", endY, indent) + "\n";
        str = str + intToString("cellsY", cellsY, indent) + "\n";
        str = str + boolToString("is3D", is3D, indent) + "\n";
        str = str + doubleToString("startZ", startZ, indent) + "\n";
        str = str + doubleToString("endZ", endZ, indent) + "\n";
        str = str + intToString("cellsZ", cellsZ, indent) + "\n";
        str = str + indent + "variableType = ";
        if(variableType == VARIABLETYPES_INTRINSIC)
            str = str + "VARIABLETYPES_INTRINSIC";
        if(variableType == VARIABLETYPES_EXTRINSIC)
            str = str + "VARIABLETYPES_EXTRINSIC";
        str = str + "\n";
        return str;
    }


    // Attributes
    private boolean useExtents;
    private double  startX;
    private double  endX;
    private int     cellsX;
    private double  startY;
    private double  endY;
    private int     cellsY;
    private boolean is3D;
    private double  startZ;
    private double  endZ;
    private int     cellsZ;
    private int     variableType;
}

