// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef REMAPATTRIBUTES_H
#define REMAPATTRIBUTES_H
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: RemapAttributes
//
// Purpose:
//    Atts for Remap operator
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class RemapAttributes : public AttributeSubject
{
public:
    enum VariableTypes
    {
        intrinsic,
        extrinsic
    };

    // These constructors are for objects of this class
    RemapAttributes();
    RemapAttributes(const RemapAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    RemapAttributes(private_tmfs_t tmfs);
    RemapAttributes(const RemapAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~RemapAttributes();

    virtual RemapAttributes& operator = (const RemapAttributes &obj);
    virtual bool operator == (const RemapAttributes &obj) const;
    virtual bool operator != (const RemapAttributes &obj) const;
private:
    void Init();
    void Copy(const RemapAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();

    // Property setting methods
    void SetUseExtents(bool useExtents_);
    void SetStartX(double startX_);
    void SetEndX(double endX_);
    void SetCellsX(int cellsX_);
    void SetStartY(double startY_);
    void SetEndY(double endY_);
    void SetCellsY(int cellsY_);
    void SetIs3D(bool is3D_);
    void SetStartZ(double startZ_);
    void SetEndZ(double endZ_);
    void SetCellsZ(int cellsZ_);
    void SetVariableType(VariableTypes variableType_);

    // Property getting methods
    bool   GetUseExtents() const;
    double GetStartX() const;
    double GetEndX() const;
    int    GetCellsX() const;
    double GetStartY() const;
    double GetEndY() const;
    int    GetCellsY() const;
    bool   GetIs3D() const;
    double GetStartZ() const;
    double GetEndZ() const;
    int    GetCellsZ() const;
    VariableTypes GetVariableType() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static std::string VariableTypes_ToString(VariableTypes);
    static bool VariableTypes_FromString(const std::string &, VariableTypes &);
protected:
    static std::string VariableTypes_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_useExtents = 0,
        ID_startX,
        ID_endX,
        ID_cellsX,
        ID_startY,
        ID_endY,
        ID_cellsY,
        ID_is3D,
        ID_startZ,
        ID_endZ,
        ID_cellsZ,
        ID_variableType,
        ID__LAST
    };

private:
    bool   useExtents;
    double startX;
    double endX;
    int    cellsX;
    double startY;
    double endY;
    int    cellsY;
    bool   is3D;
    double startZ;
    double endZ;
    int    cellsZ;
    int    variableType;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define REMAPATTRIBUTES_TMFS "bddiddibddii"

#endif
