// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include "QvisRemapWindow.h"

#include <RemapAttributes.h>

#include <QCheckBox>
#include <QLabel>
#include <QLayout>
#include <QLineEdit>
#include <QSpinBox>
#include <QButtonGroup>
#include <QRadioButton>
#include <QvisVariableButton.h>


// ****************************************************************************
// Method: QvisRemapWindow::QvisRemapWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisRemapWindow::QvisRemapWindow(const int type,
                         RemapAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisRemapWindow::~QvisRemapWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisRemapWindow::~QvisRemapWindow()
{
}


// ****************************************************************************
// Method: QvisRemapWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisRemapWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    useExtents = new QCheckBox(tr("Remap Entire Extents"), central);
    connect(useExtents, SIGNAL(toggled(bool)),
            this, SLOT(useExtentsChanged(bool)));
    mainLayout->addWidget(useExtents, 0,0);

    startXLabel = new QLabel(tr("Start X"), central);
    mainLayout->addWidget(startXLabel,1,0);
    startX = new QLineEdit(central);
    connect(startX, SIGNAL(returnPressed()),
            this, SLOT(startXProcessText()));
    mainLayout->addWidget(startX, 1,1);

    endXLabel = new QLabel(tr("End X"), central);
    mainLayout->addWidget(endXLabel,2,0);
    endX = new QLineEdit(central);
    connect(endX, SIGNAL(returnPressed()),
            this, SLOT(endXProcessText()));
    mainLayout->addWidget(endX, 2,1);

    cellsXLabel = new QLabel(tr("Cells in X"), central);
    mainLayout->addWidget(cellsXLabel,3,0);
    cellsX = new QLineEdit(central);
    connect(cellsX, SIGNAL(returnPressed()),
            this, SLOT(cellsXProcessText()));
    mainLayout->addWidget(cellsX, 3,1);

    startYLabel = new QLabel(tr("Start Y"), central);
    mainLayout->addWidget(startYLabel,4,0);
    startY = new QLineEdit(central);
    connect(startY, SIGNAL(returnPressed()),
            this, SLOT(startYProcessText()));
    mainLayout->addWidget(startY, 4,1);

    endYLabel = new QLabel(tr("End Y"), central);
    mainLayout->addWidget(endYLabel,5,0);
    endY = new QLineEdit(central);
    connect(endY, SIGNAL(returnPressed()),
            this, SLOT(endYProcessText()));
    mainLayout->addWidget(endY, 5,1);

    cellsYLabel = new QLabel(tr("Cells in Y"), central);
    mainLayout->addWidget(cellsYLabel,6,0);
    cellsY = new QLineEdit(central);
    connect(cellsY, SIGNAL(returnPressed()),
            this, SLOT(cellsYProcessText()));
    mainLayout->addWidget(cellsY, 6,1);

    is3D = new QCheckBox(tr("3D remapping"), central);
    connect(is3D, SIGNAL(toggled(bool)),
            this, SLOT(is3DChanged(bool)));
    mainLayout->addWidget(is3D, 7,0);

    startZLabel = new QLabel(tr("Start Z"), central);
    mainLayout->addWidget(startZLabel,8,0);
    startZ = new QLineEdit(central);
    connect(startZ, SIGNAL(returnPressed()),
            this, SLOT(startZProcessText()));
    mainLayout->addWidget(startZ, 8,1);

    endZLabel = new QLabel(tr("End Z"), central);
    mainLayout->addWidget(endZLabel,9,0);
    endZ = new QLineEdit(central);
    connect(endZ, SIGNAL(returnPressed()),
            this, SLOT(endZProcessText()));
    mainLayout->addWidget(endZ, 9,1);

    cellsZLabel = new QLabel(tr("Cells in Z"), central);
    mainLayout->addWidget(cellsZLabel,10,0);
    cellsZ = new QLineEdit(central);
    connect(cellsZ, SIGNAL(returnPressed()),
            this, SLOT(cellsZProcessText()));
    mainLayout->addWidget(cellsZ, 10,1);

    variableTypeLabel = new QLabel(tr("Variable type"), central);
    mainLayout->addWidget(variableTypeLabel,12,0);
    variableType = new QWidget(central);
    variableTypeButtonGroup= new QButtonGroup(variableType);
    QHBoxLayout *variableTypeLayout = new QHBoxLayout(variableType);
    variableTypeLayout->setMargin(0);
    variableTypeLayout->setSpacing(10);
    QRadioButton *variableTypeVariableTypesintrinsic = new QRadioButton(tr("intrinsic"), variableType);
    variableTypeButtonGroup->addButton(variableTypeVariableTypesintrinsic,0);
    variableTypeLayout->addWidget(variableTypeVariableTypesintrinsic);
    QRadioButton *variableTypeVariableTypesextrinsic = new QRadioButton(tr("extrinsic"), variableType);
    variableTypeButtonGroup->addButton(variableTypeVariableTypesextrinsic,1);
    variableTypeLayout->addWidget(variableTypeVariableTypesextrinsic);
    connect(variableTypeButtonGroup, SIGNAL(buttonClicked(int)),
            this, SLOT(variableTypeChanged(int)));
    mainLayout->addWidget(variableType, 12,1);

}


// ****************************************************************************
// Method: QvisRemapWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisRemapWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case RemapAttributes::ID_useExtents:
            if (atts->GetUseExtents() == false)
            {
                startX->setEnabled(true);
                startXLabel->setEnabled(true);
                endX->setEnabled(true);
                endXLabel->setEnabled(true);
                startY->setEnabled(true);
                startYLabel->setEnabled(true);
                endY->setEnabled(true);
                endYLabel->setEnabled(true);
            }
            else
            {
                startX->setEnabled(false);
                startXLabel->setEnabled(false);
                endX->setEnabled(false);
                endXLabel->setEnabled(false);
                startY->setEnabled(false);
                startYLabel->setEnabled(false);
                endY->setEnabled(false);
                endYLabel->setEnabled(false);
            }

            if (atts->GetIs3D() == true && atts->GetUseExtents() == false)
            {
                startZ->setEnabled(true);
                startZLabel->setEnabled(true);
                endZ->setEnabled(true);
                endZLabel->setEnabled(true);
            }
            else
            {
                startZ->setEnabled(false);
                startZLabel->setEnabled(false);
                endZ->setEnabled(false);
                endZLabel->setEnabled(false);
            }
            useExtents->blockSignals(true);
            useExtents->setChecked(atts->GetUseExtents());
            useExtents->blockSignals(false);
            break;
          case RemapAttributes::ID_startX:
            startX->setText(DoubleToQString(atts->GetStartX()));
            break;
          case RemapAttributes::ID_endX:
            endX->setText(DoubleToQString(atts->GetEndX()));
            break;
          case RemapAttributes::ID_cellsX:
            cellsX->setText(IntToQString(atts->GetCellsX()));
            break;
          case RemapAttributes::ID_startY:
            startY->setText(DoubleToQString(atts->GetStartY()));
            break;
          case RemapAttributes::ID_endY:
            endY->setText(DoubleToQString(atts->GetEndY()));
            break;
          case RemapAttributes::ID_cellsY:
            cellsY->setText(IntToQString(atts->GetCellsY()));
            break;
          case RemapAttributes::ID_is3D:
            if (atts->GetIs3D() == true && atts->GetUseExtents() == false)
            {
                startZ->setEnabled(true);
                startZLabel->setEnabled(true);
                endZ->setEnabled(true);
                endZLabel->setEnabled(true);
            }
            else
            {
                startZ->setEnabled(false);
                startZLabel->setEnabled(false);
                endZ->setEnabled(false);
                endZLabel->setEnabled(false);
            }
            if (atts->GetIs3D() == true)
            {
                cellsZ->setEnabled(true);
                cellsZLabel->setEnabled(true);
            }
            else
            {
                cellsZ->setEnabled(false);
                cellsZLabel->setEnabled(false);
            }
            is3D->blockSignals(true);
            is3D->setChecked(atts->GetIs3D());
            is3D->blockSignals(false);
            break;
          case RemapAttributes::ID_startZ:
            startZ->setText(DoubleToQString(atts->GetStartZ()));
            break;
          case RemapAttributes::ID_endZ:
            endZ->setText(DoubleToQString(atts->GetEndZ()));
            break;
          case RemapAttributes::ID_cellsZ:
            cellsZ->setText(IntToQString(atts->GetCellsZ()));
            break;
          case RemapAttributes::ID_variableType:
            variableTypeButtonGroup->blockSignals(true);
            if(variableTypeButtonGroup->button((int)atts->GetVariableType()) != 0)
                variableTypeButtonGroup->button((int)atts->GetVariableType())->setChecked(true);
            variableTypeButtonGroup->blockSignals(false);
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisRemapWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisRemapWindow::GetCurrentValues(int which_widget)
{
    bool doAll = (which_widget == -1);

    // Do startX
    if(which_widget == RemapAttributes::ID_startX || doAll)
    {
        double val;
        if(LineEditGetDouble(startX, val))
            atts->SetStartX(val);
        else
        {
            ResettingError(tr("Start X"),
                DoubleToQString(atts->GetStartX()));
            atts->SetStartX(atts->GetStartX());
        }
    }

    // Do endX
    if(which_widget == RemapAttributes::ID_endX || doAll)
    {
        double val;
        if(LineEditGetDouble(endX, val))
            atts->SetEndX(val);
        else
        {
            ResettingError(tr("End X"),
                DoubleToQString(atts->GetEndX()));
            atts->SetEndX(atts->GetEndX());
        }
    }

    // Do cellsX
    if(which_widget == RemapAttributes::ID_cellsX || doAll)
    {
        int val;
        if(LineEditGetInt(cellsX, val))
            atts->SetCellsX(val);
        else
        {
            ResettingError(tr("Cells in X"),
                IntToQString(atts->GetCellsX()));
            atts->SetCellsX(atts->GetCellsX());
        }
    }

    // Do startY
    if(which_widget == RemapAttributes::ID_startY || doAll)
    {
        double val;
        if(LineEditGetDouble(startY, val))
            atts->SetStartY(val);
        else
        {
            ResettingError(tr("Start Y"),
                DoubleToQString(atts->GetStartY()));
            atts->SetStartY(atts->GetStartY());
        }
    }

    // Do endY
    if(which_widget == RemapAttributes::ID_endY || doAll)
    {
        double val;
        if(LineEditGetDouble(endY, val))
            atts->SetEndY(val);
        else
        {
            ResettingError(tr("End Y"),
                DoubleToQString(atts->GetEndY()));
            atts->SetEndY(atts->GetEndY());
        }
    }

    // Do cellsY
    if(which_widget == RemapAttributes::ID_cellsY || doAll)
    {
        int val;
        if(LineEditGetInt(cellsY, val))
            atts->SetCellsY(val);
        else
        {
            ResettingError(tr("Cells in Y"),
                IntToQString(atts->GetCellsY()));
            atts->SetCellsY(atts->GetCellsY());
        }
    }

    // Do startZ
    if(which_widget == RemapAttributes::ID_startZ || doAll)
    {
        double val;
        if(LineEditGetDouble(startZ, val))
            atts->SetStartZ(val);
        else
        {
            ResettingError(tr("Start Z"),
                DoubleToQString(atts->GetStartZ()));
            atts->SetStartZ(atts->GetStartZ());
        }
    }

    // Do endZ
    if(which_widget == RemapAttributes::ID_endZ || doAll)
    {
        double val;
        if(LineEditGetDouble(endZ, val))
            atts->SetEndZ(val);
        else
        {
            ResettingError(tr("End Z"),
                DoubleToQString(atts->GetEndZ()));
            atts->SetEndZ(atts->GetEndZ());
        }
    }

    // Do cellsZ
    if(which_widget == RemapAttributes::ID_cellsZ || doAll)
    {
        int val;
        if(LineEditGetInt(cellsZ, val))
            atts->SetCellsZ(val);
        else
        {
            ResettingError(tr("Cells in Z"),
                IntToQString(atts->GetCellsZ()));
            atts->SetCellsZ(atts->GetCellsZ());
        }
    }
}


//
// Qt Slot functions
//


void
QvisRemapWindow::useExtentsChanged(bool val)
{
    atts->SetUseExtents(val);
    Apply();
}


void
QvisRemapWindow::startXProcessText()
{
    GetCurrentValues(RemapAttributes::ID_startX);
    Apply();
}


void
QvisRemapWindow::endXProcessText()
{
    GetCurrentValues(RemapAttributes::ID_endX);
    Apply();
}


void
QvisRemapWindow::cellsXProcessText()
{
    GetCurrentValues(RemapAttributes::ID_cellsX);
    Apply();
}


void
QvisRemapWindow::startYProcessText()
{
    GetCurrentValues(RemapAttributes::ID_startY);
    Apply();
}


void
QvisRemapWindow::endYProcessText()
{
    GetCurrentValues(RemapAttributes::ID_endY);
    Apply();
}


void
QvisRemapWindow::cellsYProcessText()
{
    GetCurrentValues(RemapAttributes::ID_cellsY);
    Apply();
}


void
QvisRemapWindow::is3DChanged(bool val)
{
    atts->SetIs3D(val);
    Apply();
}


void
QvisRemapWindow::startZProcessText()
{
    GetCurrentValues(RemapAttributes::ID_startZ);
    Apply();
}


void
QvisRemapWindow::endZProcessText()
{
    GetCurrentValues(RemapAttributes::ID_endZ);
    Apply();
}


void
QvisRemapWindow::cellsZProcessText()
{
    GetCurrentValues(RemapAttributes::ID_cellsZ);
    Apply();
}


void
QvisRemapWindow::variableTypeChanged(int val)
{
    if(val != atts->GetVariableType())
    {
        atts->SetVariableType(RemapAttributes::VariableTypes(val));
        SetUpdate(false);
        Apply();
    }
}


