// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ReflectGUIPluginInfo.C
// ****************************************************************************

#include <ReflectPluginInfo.h>
#include <ReflectAttributes.h>
#include <QApplication>
#include <QvisReflectWindow.h>

VISIT_OPERATOR_PLUGIN_ENTRY(Reflect,GUI)

// ****************************************************************************
//  Method: ReflectGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QString *
ReflectGUIPluginInfo::GetMenuName() const
{
    return new QString(qApp->translate("OperatorNames", "Reflect"));
}


// ****************************************************************************
//  Method: ReflectGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QvisPostableWindowObserver *
ReflectGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    const QString &caption, const QString &shortName, QvisNotepadArea *notepad)
{
    return new QvisReflectWindow(type, (ReflectAttributes *)attr,
        caption, shortName, notepad);
}

// ****************************************************************************
//  Method: ReflectGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

#include <Reflect.xpm>
const char **
ReflectGUIPluginInfo::XPMIconData() const
{
    return Reflect_xpm;
}

