// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef REFLECTATTRIBUTES_H
#define REFLECTATTRIBUTES_H
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: ReflectAttributes
//
// Purpose:
//    This class contains attributes for the reflect operator.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class ReflectAttributes : public AttributeSubject
{
public:
    enum Octant
    {
        PXPYPZ,
        NXPYPZ,
        PXNYPZ,
        NXNYPZ,
        PXPYNZ,
        NXPYNZ,
        PXNYNZ,
        NXNYNZ
    };
    enum ReflectType
    {
        Plane,
        Axis
    };

    // These constructors are for objects of this class
    ReflectAttributes();
    ReflectAttributes(const ReflectAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    ReflectAttributes(private_tmfs_t tmfs);
    ReflectAttributes(const ReflectAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~ReflectAttributes();

    virtual ReflectAttributes& operator = (const ReflectAttributes &obj);
    virtual bool operator == (const ReflectAttributes &obj) const;
    virtual bool operator != (const ReflectAttributes &obj) const;
private:
    void Init();
    void Copy(const ReflectAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectReflections();
    void SelectPlanePoint();
    void SelectPlaneNormal();

    // Property setting methods
    void SetOctant(Octant octant_);
    void SetUseXBoundary(bool useXBoundary_);
    void SetSpecifiedX(double specifiedX_);
    void SetUseYBoundary(bool useYBoundary_);
    void SetSpecifiedY(double specifiedY_);
    void SetUseZBoundary(bool useZBoundary_);
    void SetSpecifiedZ(double specifiedZ_);
    void SetReflections(const int *reflections_);
    void SetPlanePoint(const double *planePoint_);
    void SetPlaneNormal(const double *planeNormal_);
    void SetReflectType(ReflectType reflectType_);

    // Property getting methods
    Octant       GetOctant() const;
    bool         GetUseXBoundary() const;
    double       GetSpecifiedX() const;
    bool         GetUseYBoundary() const;
    double       GetSpecifiedY() const;
    bool         GetUseZBoundary() const;
    double       GetSpecifiedZ() const;
    const int    *GetReflections() const;
          int    *GetReflections();
    const double *GetPlanePoint() const;
          double *GetPlanePoint();
    const double *GetPlaneNormal() const;
          double *GetPlaneNormal();
    ReflectType  GetReflectType() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);

    // Enum conversion functions
    static std::string Octant_ToString(Octant);
    static bool Octant_FromString(const std::string &, Octant &);
protected:
    static std::string Octant_ToString(int);
public:
    static std::string ReflectType_ToString(ReflectType);
    static bool ReflectType_FromString(const std::string &, ReflectType &);
protected:
    static std::string ReflectType_ToString(int);
public:

    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    virtual void ProcessOldVersions(DataNode *node, const char *configVersion);

    // IDs that can be used to identify fields in case statements
    enum {
        ID_octant = 0,
        ID_useXBoundary,
        ID_specifiedX,
        ID_useYBoundary,
        ID_specifiedY,
        ID_useZBoundary,
        ID_specifiedZ,
        ID_reflections,
        ID_planePoint,
        ID_planeNormal,
        ID_reflectType,
        ID__LAST
    };

protected:
    double planePoint[3];
    double planeNormal[3];
    int    reflectType;
private:
    int    octant;
    bool   useXBoundary;
    double specifiedX;
    bool   useYBoundary;
    double specifiedY;
    bool   useZBoundary;
    double specifiedZ;
    int    reflections[8];

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define REFLECTATTRIBUTES_TMFS "ibdbdbdIDDi"

#endif
