// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: RadialResampleViewerEnginePluginInfo.C
// ****************************************************************************

#include <RadialResamplePluginInfo.h>
#include <RadialResampleAttributes.h>

//
// Storage for static data elements.
//
RadialResampleAttributes *RadialResampleViewerEnginePluginInfo::clientAtts = NULL;
RadialResampleAttributes *RadialResampleViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  RadialResampleViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
RadialResampleViewerEnginePluginInfo::InitializeGlobalObjects()
{
    if (RadialResampleViewerEnginePluginInfo::clientAtts == NULL)
    {
        RadialResampleViewerEnginePluginInfo::clientAtts  = new RadialResampleAttributes;
        RadialResampleViewerEnginePluginInfo::defaultAtts = new RadialResampleAttributes;
    }
}

// ****************************************************************************
//  Method: RadialResampleViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
RadialResampleViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: RadialResampleViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
RadialResampleViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: RadialResampleViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
RadialResampleViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(RadialResampleAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: RadialResampleViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
RadialResampleViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(RadialResampleAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: RadialResampleViewerEnginePluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts        The attribute subject to initialize.
//    plot        The viewer plot that owns the operator.
//    fromDefault True to initialize the attributes from the defaults. False
//                to initialize from the current attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
RadialResampleViewerEnginePluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const avtPlotMetaData &plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(RadialResampleAttributes*)atts = *defaultAtts;
    else
        *(RadialResampleAttributes*)atts = *clientAtts;

    UpdateOperatorAtts(atts, plot);
}

// ****************************************************************************
//  Method: RadialResampleViewerEnginePluginInfo::UpdateOperatorAtts
//
//  Purpose:
//    Update the operator attributes when using operator expressions.
//
//  Arguments:
//    atts        The attribute subject to update.
//    plot        The viewer plot that owns the operator.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
RadialResampleViewerEnginePluginInfo::UpdateOperatorAtts(AttributeSubject *atts, const avtPlotMetaData &plot)
{
}

// ****************************************************************************
//  Method: RadialResampleViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
RadialResampleViewerEnginePluginInfo::GetMenuName() const
{
    return "Radial Resample";
}

