// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  RadialResampleScriptingPluginInfo.C
// ************************************************************************* //
#include <PyRadialResampleAttributes.h>
#include <RadialResamplePluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(RadialResample,Scripting)

// ****************************************************************************
// Method: RadialResampleScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
RadialResampleScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyRadialResampleAttributes_StartUp((RadialResampleAttributes *)subj, data);
}

// ****************************************************************************
// Method: RadialResampleScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
RadialResampleScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyRadialResampleAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: RadialResampleScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is RadialResample plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
RadialResampleScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyRadialResampleAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: RadialResampleScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
RadialResampleScriptingPluginInfo::GetLogString()
{
    std::string s(PyRadialResampleAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: RadialResampleScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
RadialResampleScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyRadialResampleAttributes_SetDefaults((const RadialResampleAttributes *)atts);
}
