// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: RadialResamplePluginInfo.h
// ****************************************************************************

#ifndef RADIALRESAMPLE_PLUGIN_INFO_H
#define RADIALRESAMPLE_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class RadialResampleAttributes;

// ****************************************************************************
//  Class: RadialResamplePluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an RadialResample operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class RadialResampleGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class RadialResampleCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual RadialResampleGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class RadialResampleGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual RadialResampleCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
};

class RadialResampleViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual RadialResampleCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;

    static void InitializeGlobalObjects();
  private:
    static RadialResampleAttributes *defaultAtts;
    static RadialResampleAttributes *clientAtts;
};

class RadialResampleViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual RadialResampleViewerEnginePluginInfo
{
  public:
};

class RadialResampleEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual RadialResampleViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class RadialResampleScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual RadialResampleCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
