// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: RadialResamplePluginInfo.C
// ****************************************************************************

#include <RadialResamplePluginInfo.h>
#include <RadialResampleAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(RadialResample,OP_EXPORT)

VISIT_OPERATOR_PLUGIN_ENTRY(RadialResample,General)

// ****************************************************************************
//  Method: RadialResampleGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the operator plugin.
//
//  Returns:    A pointer to the name of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
RadialResampleGeneralPluginInfo::GetName() const
{
    return "RadialResample";
}

// ****************************************************************************
//  Method: RadialResampleGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the operator plugin.
//
//  Returns:    A pointer to the version of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
RadialResampleGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: RadialResampleGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the operator plugin.
//
//  Returns:    A pointer to the id of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
RadialResampleGeneralPluginInfo::GetID() const
{
    return "RadialResample_1.0";
}
// ****************************************************************************
//  Method: RadialResampleGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
RadialResampleGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}

// ****************************************************************************
//  Method: RadialResampleGeneralPluginInfo::GetCategoryName
//
//  Purpose:
//    Return the category name to which the operator belongs.
//
//  Returns:    Return the category name to which the operator belongs.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
RadialResampleGeneralPluginInfo::GetCategoryName() const
{
    return "Geometry";
}
