// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef RADIALRESAMPLEATTRIBUTES_H
#define RADIALRESAMPLEATTRIBUTES_H
#include <AttributeSubject.h>


// ****************************************************************************
// Class: RadialResampleAttributes
//
// Purpose:
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class RadialResampleAttributes : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    RadialResampleAttributes();
    RadialResampleAttributes(const RadialResampleAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    RadialResampleAttributes(private_tmfs_t tmfs);
    RadialResampleAttributes(const RadialResampleAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~RadialResampleAttributes();

    virtual RadialResampleAttributes& operator = (const RadialResampleAttributes &obj);
    virtual bool operator == (const RadialResampleAttributes &obj) const;
    virtual bool operator != (const RadialResampleAttributes &obj) const;
private:
    void Init();
    void Copy(const RadialResampleAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectCenter();

    // Property setting methods
    void SetIsFast(bool isFast_);
    void SetMinTheta(float minTheta_);
    void SetMaxTheta(float maxTheta_);
    void SetDeltaTheta(float deltaTheta_);
    void SetRadius(float radius_);
    void SetDeltaRadius(float deltaRadius_);
    void SetCenter(const float *center_);
    void SetIs3D(bool is3D_);
    void SetMinAzimuth(float minAzimuth_);
    void SetMaxAzimuth(float maxAzimuth_);
    void SetDeltaAzimuth(float deltaAzimuth_);

    // Property getting methods
    bool        GetIsFast() const;
    float       GetMinTheta() const;
    float       GetMaxTheta() const;
    float       GetDeltaTheta() const;
    float       GetRadius() const;
    float       GetDeltaRadius() const;
    const float *GetCenter() const;
          float *GetCenter();
    bool        GetIs3D() const;
    float       GetMinAzimuth() const;
    float       GetMaxAzimuth() const;
    float       GetDeltaAzimuth() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_isFast = 0,
        ID_minTheta,
        ID_maxTheta,
        ID_deltaTheta,
        ID_radius,
        ID_deltaRadius,
        ID_center,
        ID_is3D,
        ID_minAzimuth,
        ID_maxAzimuth,
        ID_deltaAzimuth,
        ID__LAST
    };

private:
    bool  isFast;
    float minTheta;
    float maxTheta;
    float deltaTheta;
    float radius;
    float deltaRadius;
    float center[3];
    bool  is3D;
    float minAzimuth;
    float maxAzimuth;
    float deltaAzimuth;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define RADIALRESAMPLEATTRIBUTES_TMFS "bfffffFbfff"

#endif
