// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <RadialResampleAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: RadialResampleAttributes::RadialResampleAttributes
//
// Purpose:
//   Init utility for the RadialResampleAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void RadialResampleAttributes::Init()
{
    isFast = false;
    minTheta = 0;
    maxTheta = 90;
    deltaTheta = 5;
    radius = 0.5;
    deltaRadius = 0.05;
    center[0] = 0.5;
    center[1] = 0.5;
    center[2] = 0.5;
    is3D = true;
    minAzimuth = 0;
    maxAzimuth = 180;
    deltaAzimuth = 5;

    RadialResampleAttributes::SelectAll();
}

// ****************************************************************************
// Method: RadialResampleAttributes::RadialResampleAttributes
//
// Purpose:
//   Copy utility for the RadialResampleAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void RadialResampleAttributes::Copy(const RadialResampleAttributes &obj)
{
    isFast = obj.isFast;
    minTheta = obj.minTheta;
    maxTheta = obj.maxTheta;
    deltaTheta = obj.deltaTheta;
    radius = obj.radius;
    deltaRadius = obj.deltaRadius;
    center[0] = obj.center[0];
    center[1] = obj.center[1];
    center[2] = obj.center[2];

    is3D = obj.is3D;
    minAzimuth = obj.minAzimuth;
    maxAzimuth = obj.maxAzimuth;
    deltaAzimuth = obj.deltaAzimuth;

    RadialResampleAttributes::SelectAll();
}

// Type map format string
const char *RadialResampleAttributes::TypeMapFormatString = RADIALRESAMPLEATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t RadialResampleAttributes::TmfsStruct = {RADIALRESAMPLEATTRIBUTES_TMFS};


// ****************************************************************************
// Method: RadialResampleAttributes::RadialResampleAttributes
//
// Purpose:
//   Default constructor for the RadialResampleAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

RadialResampleAttributes::RadialResampleAttributes() :
    AttributeSubject(RadialResampleAttributes::TypeMapFormatString)
{
    RadialResampleAttributes::Init();
}

// ****************************************************************************
// Method: RadialResampleAttributes::RadialResampleAttributes
//
// Purpose:
//   Constructor for the derived classes of RadialResampleAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

RadialResampleAttributes::RadialResampleAttributes(private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    RadialResampleAttributes::Init();
}

// ****************************************************************************
// Method: RadialResampleAttributes::RadialResampleAttributes
//
// Purpose:
//   Copy constructor for the RadialResampleAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

RadialResampleAttributes::RadialResampleAttributes(const RadialResampleAttributes &obj) :
    AttributeSubject(RadialResampleAttributes::TypeMapFormatString)
{
    RadialResampleAttributes::Copy(obj);
}

// ****************************************************************************
// Method: RadialResampleAttributes::RadialResampleAttributes
//
// Purpose:
//   Copy constructor for derived classes of the RadialResampleAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

RadialResampleAttributes::RadialResampleAttributes(const RadialResampleAttributes &obj, private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    RadialResampleAttributes::Copy(obj);
}

// ****************************************************************************
// Method: RadialResampleAttributes::~RadialResampleAttributes
//
// Purpose:
//   Destructor for the RadialResampleAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

RadialResampleAttributes::~RadialResampleAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: RadialResampleAttributes::operator =
//
// Purpose:
//   Assignment operator for the RadialResampleAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

RadialResampleAttributes&
RadialResampleAttributes::operator = (const RadialResampleAttributes &obj)
{
    if (this == &obj) return *this;

    RadialResampleAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: RadialResampleAttributes::operator ==
//
// Purpose:
//   Comparison operator == for the RadialResampleAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
RadialResampleAttributes::operator == (const RadialResampleAttributes &obj) const
{
    // Compare the center arrays.
    bool center_equal = true;
    for(int i = 0; i < 3 && center_equal; ++i)
        center_equal = (center[i] == obj.center[i]);

    // Create the return value
    return ((isFast == obj.isFast) &&
            (minTheta == obj.minTheta) &&
            (maxTheta == obj.maxTheta) &&
            (deltaTheta == obj.deltaTheta) &&
            (radius == obj.radius) &&
            (deltaRadius == obj.deltaRadius) &&
            center_equal &&
            (is3D == obj.is3D) &&
            (minAzimuth == obj.minAzimuth) &&
            (maxAzimuth == obj.maxAzimuth) &&
            (deltaAzimuth == obj.deltaAzimuth));
}

// ****************************************************************************
// Method: RadialResampleAttributes::operator !=
//
// Purpose:
//   Comparison operator != for the RadialResampleAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
RadialResampleAttributes::operator != (const RadialResampleAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: RadialResampleAttributes::TypeName
//
// Purpose:
//   Type name method for the RadialResampleAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

const std::string
RadialResampleAttributes::TypeName() const
{
    return "RadialResampleAttributes";
}

// ****************************************************************************
// Method: RadialResampleAttributes::CopyAttributes
//
// Purpose:
//   CopyAttributes method for the RadialResampleAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
RadialResampleAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const RadialResampleAttributes *tmp = (const RadialResampleAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: RadialResampleAttributes::CreateCompatible
//
// Purpose:
//   CreateCompatible method for the RadialResampleAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
RadialResampleAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new RadialResampleAttributes(*this);
    // Other cases could go here too.

    return retval;
}

// ****************************************************************************
// Method: RadialResampleAttributes::NewInstance
//
// Purpose:
//   NewInstance method for the RadialResampleAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
RadialResampleAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new RadialResampleAttributes(*this);
    else
        retval = new RadialResampleAttributes;

    return retval;
}

// ****************************************************************************
// Method: RadialResampleAttributes::SelectAll
//
// Purpose:
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
RadialResampleAttributes::SelectAll()
{
    Select(ID_isFast,       (void *)&isFast);
    Select(ID_minTheta,     (void *)&minTheta);
    Select(ID_maxTheta,     (void *)&maxTheta);
    Select(ID_deltaTheta,   (void *)&deltaTheta);
    Select(ID_radius,       (void *)&radius);
    Select(ID_deltaRadius,  (void *)&deltaRadius);
    Select(ID_center,       (void *)center, 3);
    Select(ID_is3D,         (void *)&is3D);
    Select(ID_minAzimuth,   (void *)&minAzimuth);
    Select(ID_maxAzimuth,   (void *)&maxAzimuth);
    Select(ID_deltaAzimuth, (void *)&deltaAzimuth);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: RadialResampleAttributes::CreateNode
//
// Purpose:
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
RadialResampleAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    RadialResampleAttributes defaultObject;
    bool addToParent = false;
    // Create a node for RadialResampleAttributes.
    DataNode *node = new DataNode("RadialResampleAttributes");

    if(completeSave || !FieldsEqual(ID_isFast, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("isFast", isFast));
    }

    if(completeSave || !FieldsEqual(ID_minTheta, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("minTheta", minTheta));
    }

    if(completeSave || !FieldsEqual(ID_maxTheta, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("maxTheta", maxTheta));
    }

    if(completeSave || !FieldsEqual(ID_deltaTheta, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("deltaTheta", deltaTheta));
    }

    if(completeSave || !FieldsEqual(ID_radius, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("radius", radius));
    }

    if(completeSave || !FieldsEqual(ID_deltaRadius, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("deltaRadius", deltaRadius));
    }

    if(completeSave || !FieldsEqual(ID_center, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("center", center, 3));
    }

    if(completeSave || !FieldsEqual(ID_is3D, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("is3D", is3D));
    }

    if(completeSave || !FieldsEqual(ID_minAzimuth, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("minAzimuth", minAzimuth));
    }

    if(completeSave || !FieldsEqual(ID_maxAzimuth, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("maxAzimuth", maxAzimuth));
    }

    if(completeSave || !FieldsEqual(ID_deltaAzimuth, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("deltaAzimuth", deltaAzimuth));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: RadialResampleAttributes::SetFromNode
//
// Purpose:
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
RadialResampleAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("RadialResampleAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("isFast")) != 0)
        SetIsFast(node->AsBool());
    if((node = searchNode->GetNode("minTheta")) != 0)
        SetMinTheta(node->AsFloat());
    if((node = searchNode->GetNode("maxTheta")) != 0)
        SetMaxTheta(node->AsFloat());
    if((node = searchNode->GetNode("deltaTheta")) != 0)
        SetDeltaTheta(node->AsFloat());
    if((node = searchNode->GetNode("radius")) != 0)
        SetRadius(node->AsFloat());
    if((node = searchNode->GetNode("deltaRadius")) != 0)
        SetDeltaRadius(node->AsFloat());
    if((node = searchNode->GetNode("center")) != 0)
        SetCenter(node->AsFloatArray());
    if((node = searchNode->GetNode("is3D")) != 0)
        SetIs3D(node->AsBool());
    if((node = searchNode->GetNode("minAzimuth")) != 0)
        SetMinAzimuth(node->AsFloat());
    if((node = searchNode->GetNode("maxAzimuth")) != 0)
        SetMaxAzimuth(node->AsFloat());
    if((node = searchNode->GetNode("deltaAzimuth")) != 0)
        SetDeltaAzimuth(node->AsFloat());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
RadialResampleAttributes::SetIsFast(bool isFast_)
{
    isFast = isFast_;
    Select(ID_isFast, (void *)&isFast);
}

void
RadialResampleAttributes::SetMinTheta(float minTheta_)
{
    minTheta = minTheta_;
    Select(ID_minTheta, (void *)&minTheta);
}

void
RadialResampleAttributes::SetMaxTheta(float maxTheta_)
{
    maxTheta = maxTheta_;
    Select(ID_maxTheta, (void *)&maxTheta);
}

void
RadialResampleAttributes::SetDeltaTheta(float deltaTheta_)
{
    deltaTheta = deltaTheta_;
    Select(ID_deltaTheta, (void *)&deltaTheta);
}

void
RadialResampleAttributes::SetRadius(float radius_)
{
    radius = radius_;
    Select(ID_radius, (void *)&radius);
}

void
RadialResampleAttributes::SetDeltaRadius(float deltaRadius_)
{
    deltaRadius = deltaRadius_;
    Select(ID_deltaRadius, (void *)&deltaRadius);
}

void
RadialResampleAttributes::SetCenter(const float *center_)
{
    center[0] = center_[0];
    center[1] = center_[1];
    center[2] = center_[2];
    Select(ID_center, (void *)center, 3);
}

void
RadialResampleAttributes::SetIs3D(bool is3D_)
{
    is3D = is3D_;
    Select(ID_is3D, (void *)&is3D);
}

void
RadialResampleAttributes::SetMinAzimuth(float minAzimuth_)
{
    minAzimuth = minAzimuth_;
    Select(ID_minAzimuth, (void *)&minAzimuth);
}

void
RadialResampleAttributes::SetMaxAzimuth(float maxAzimuth_)
{
    maxAzimuth = maxAzimuth_;
    Select(ID_maxAzimuth, (void *)&maxAzimuth);
}

void
RadialResampleAttributes::SetDeltaAzimuth(float deltaAzimuth_)
{
    deltaAzimuth = deltaAzimuth_;
    Select(ID_deltaAzimuth, (void *)&deltaAzimuth);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

bool
RadialResampleAttributes::GetIsFast() const
{
    return isFast;
}

float
RadialResampleAttributes::GetMinTheta() const
{
    return minTheta;
}

float
RadialResampleAttributes::GetMaxTheta() const
{
    return maxTheta;
}

float
RadialResampleAttributes::GetDeltaTheta() const
{
    return deltaTheta;
}

float
RadialResampleAttributes::GetRadius() const
{
    return radius;
}

float
RadialResampleAttributes::GetDeltaRadius() const
{
    return deltaRadius;
}

const float *
RadialResampleAttributes::GetCenter() const
{
    return center;
}

float *
RadialResampleAttributes::GetCenter()
{
    return center;
}

bool
RadialResampleAttributes::GetIs3D() const
{
    return is3D;
}

float
RadialResampleAttributes::GetMinAzimuth() const
{
    return minAzimuth;
}

float
RadialResampleAttributes::GetMaxAzimuth() const
{
    return maxAzimuth;
}

float
RadialResampleAttributes::GetDeltaAzimuth() const
{
    return deltaAzimuth;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
RadialResampleAttributes::SelectCenter()
{
    Select(ID_center, (void *)center, 3);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: RadialResampleAttributes::GetFieldName
//
// Purpose:
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
RadialResampleAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_isFast:       return "isFast";
    case ID_minTheta:     return "minTheta";
    case ID_maxTheta:     return "maxTheta";
    case ID_deltaTheta:   return "deltaTheta";
    case ID_radius:       return "radius";
    case ID_deltaRadius:  return "deltaRadius";
    case ID_center:       return "center";
    case ID_is3D:         return "is3D";
    case ID_minAzimuth:   return "minAzimuth";
    case ID_maxAzimuth:   return "maxAzimuth";
    case ID_deltaAzimuth: return "deltaAzimuth";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: RadialResampleAttributes::GetFieldType
//
// Purpose:
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeGroup::FieldType
RadialResampleAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_isFast:       return FieldType_bool;
    case ID_minTheta:     return FieldType_float;
    case ID_maxTheta:     return FieldType_float;
    case ID_deltaTheta:   return FieldType_float;
    case ID_radius:       return FieldType_float;
    case ID_deltaRadius:  return FieldType_float;
    case ID_center:       return FieldType_floatArray;
    case ID_is3D:         return FieldType_bool;
    case ID_minAzimuth:   return FieldType_float;
    case ID_maxAzimuth:   return FieldType_float;
    case ID_deltaAzimuth: return FieldType_float;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: RadialResampleAttributes::GetFieldTypeName
//
// Purpose:
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
RadialResampleAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_isFast:       return "bool";
    case ID_minTheta:     return "float";
    case ID_maxTheta:     return "float";
    case ID_deltaTheta:   return "float";
    case ID_radius:       return "float";
    case ID_deltaRadius:  return "float";
    case ID_center:       return "floatArray";
    case ID_is3D:         return "bool";
    case ID_minAzimuth:   return "float";
    case ID_maxAzimuth:   return "float";
    case ID_deltaAzimuth: return "float";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: RadialResampleAttributes::FieldsEqual
//
// Purpose:
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
RadialResampleAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const RadialResampleAttributes &obj = *((const RadialResampleAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_isFast:
        {  // new scope
        retval = (isFast == obj.isFast);
        }
        break;
    case ID_minTheta:
        {  // new scope
        retval = (minTheta == obj.minTheta);
        }
        break;
    case ID_maxTheta:
        {  // new scope
        retval = (maxTheta == obj.maxTheta);
        }
        break;
    case ID_deltaTheta:
        {  // new scope
        retval = (deltaTheta == obj.deltaTheta);
        }
        break;
    case ID_radius:
        {  // new scope
        retval = (radius == obj.radius);
        }
        break;
    case ID_deltaRadius:
        {  // new scope
        retval = (deltaRadius == obj.deltaRadius);
        }
        break;
    case ID_center:
        {  // new scope
        // Compare the center arrays.
        bool center_equal = true;
        for(int i = 0; i < 3 && center_equal; ++i)
            center_equal = (center[i] == obj.center[i]);

        retval = center_equal;
        }
        break;
    case ID_is3D:
        {  // new scope
        retval = (is3D == obj.is3D);
        }
        break;
    case ID_minAzimuth:
        {  // new scope
        retval = (minAzimuth == obj.minAzimuth);
        }
        break;
    case ID_maxAzimuth:
        {  // new scope
        retval = (maxAzimuth == obj.maxAzimuth);
        }
        break;
    case ID_deltaAzimuth:
        {  // new scope
        retval = (deltaAzimuth == obj.deltaAzimuth);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

