// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef QVISRADIALRESAMPLEWINDOW_H
#define QVISRADIALRESAMPLEWINDOW_H

#include <QvisOperatorWindow.h>
#include <AttributeSubject.h>

class RadialResampleAttributes;
class QLabel;
class QCheckBox;
class QLineEdit;

// ****************************************************************************
// Class: QvisRadialResampleWindow
//
// Purpose:
//    Defines QvisRadialResampleWindow class.
//
// Notes:      Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

class QvisRadialResampleWindow : public QvisOperatorWindow
{
    Q_OBJECT
  public:
    QvisRadialResampleWindow(const int type,
                         RadialResampleAttributes *subj,
                         const QString &caption = QString::null,
                         const QString &shortName = QString::null,
                         QvisNotepadArea *notepad = 0);
    virtual ~QvisRadialResampleWindow();
    virtual void CreateWindowContents();
  protected:
    void UpdateWindow(bool doAll);
    virtual void GetCurrentValues(int which_widget);
  private slots:
    void isFastChanged(bool val);
    void minThetaProcessText();
    void maxThetaProcessText();
    void deltaThetaProcessText();
    void radiusProcessText();
    void deltaRadiusProcessText();
    void centerProcessText();
    void is3DChanged(bool val);
    void minAzimuthProcessText();
    void maxAzimuthProcessText();
    void deltaAzimuthProcessText();
  private:
    QCheckBox *isFast;
    QLineEdit *minTheta;
    QLineEdit *maxTheta;
    QLineEdit *deltaTheta;
    QLineEdit *radius;
    QLineEdit *deltaRadius;
    QLineEdit *center;
    QCheckBox *is3D;
    QLineEdit *minAzimuth;
    QLineEdit *maxAzimuth;
    QLineEdit *deltaAzimuth;
    QLabel *minThetaLabel;
    QLabel *maxThetaLabel;
    QLabel *deltaThetaLabel;
    QLabel *radiusLabel;
    QLabel *deltaRadiusLabel;
    QLabel *centerLabel;
    QLabel *minAzimuthLabel;
    QLabel *maxAzimuthLabel;
    QLabel *deltaAzimuthLabel;

    RadialResampleAttributes *atts;
};



#endif
