// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include "QvisProjectWindow.h"

#include <ProjectAttributes.h>

#include <QLabel>
#include <QLayout>
#include <QComboBox>


// ****************************************************************************
// Method: QvisProjectWindow::QvisProjectWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisProjectWindow::QvisProjectWindow(const int type,
                         ProjectAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisProjectWindow::~QvisProjectWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisProjectWindow::~QvisProjectWindow()
{
}


// ****************************************************************************
// Method: QvisProjectWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   Kathleen Biagas, Mon Aug 12 16:17:34 PDT 2013
//   Change notation that shows coordinate mapping.
//
// ****************************************************************************

void
QvisProjectWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    QLabel *projectionTypeLabel = new QLabel(tr("Projection type"), central);
    mainLayout->addWidget(projectionTypeLabel,0,0);

    projectionTypeCombo = new QComboBox(central);

    projectionTypeCombo->addItem(tr("X-Axis Cartesian (x' = z, y' = y)"));
    projectionTypeCombo->addItem(tr("Y-Axis Cartesian (x' = x, y' = z)"));
    projectionTypeCombo->addItem(tr("Z-Axis Cartesian (x' = x, y' = y)"));
    projectionTypeCombo->addItem(tr("X-Axis Cylindrical (x' = x, y' = r)"));
    projectionTypeCombo->addItem(tr("Y-Axis Cylindrical (x' = y, y' = r)"));
    projectionTypeCombo->addItem(tr("Z-Axis Cylindrical (x' = z, y' = r)"));
    connect(projectionTypeCombo, SIGNAL(activated(int)),
            this, SLOT(projectionTypeChanged(int)));
    mainLayout->addWidget(projectionTypeCombo, 0,1);

    QLabel *vectorMethodLabel = new QLabel(tr("Vector transform method:"),
                                           central);
    mainLayout->addWidget(vectorMethodLabel, 1,0);
    vectorMethodCombo = new QComboBox(central);
    vectorMethodCombo->addItem(tr("No transformation"));
    vectorMethodCombo->addItem(tr("Treat as point coordinates"));
    vectorMethodCombo->addItem(tr("Treat as coordinate displacements"));
    vectorMethodCombo->addItem(tr("Treat as instantaneous directions"));
    connect(vectorMethodCombo, SIGNAL(activated(int)),
           this, SLOT(vectorMethodChanged(int)));
    mainLayout->addWidget(vectorMethodCombo, 1,1);
}


// ****************************************************************************
// Method: QvisProjectWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisProjectWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case ProjectAttributes::ID_projectionType:
            projectionTypeCombo->blockSignals(true);
            projectionTypeCombo->setCurrentIndex((int)atts->GetProjectionType());
            projectionTypeCombo->blockSignals(false);
            break;

          case ProjectAttributes::ID_vectorTransformMethod:
            vectorMethodCombo->blockSignals(true);
            vectorMethodCombo->setCurrentIndex((int)atts->GetVectorTransformMethod());
            vectorMethodCombo->blockSignals(false);
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisProjectWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//help/en_US/relnotes2.0.0.html
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisProjectWindow::GetCurrentValues(int which_widget)
{
}


//
// Qt Slot functions
//


void
QvisProjectWindow::projectionTypeChanged(int val)
{
    if(val != atts->GetProjectionType())
    {
        atts->SetProjectionType(ProjectAttributes::ProjectionType(val));
        SetUpdate(false);
        Apply();
    }
}


void
QvisProjectWindow::vectorMethodChanged(int v)
{
    atts->SetVectorTransformMethod(
                                ProjectAttributes::VectorTransformMethod(v));
}
